/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.MultiTextEditWithProgress;
import org.eclipse.core.filebuffers.manipulation.RemoveTrailingWhitespaceOperation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.filebuffers.Progress;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.containers.ZipEntryStorage;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.CompositeActionGroup;
import org.eclipse.php.internal.ui.actions.EditExternalBreakpointAction;
import org.eclipse.php.internal.ui.actions.GotoMatchingBracketAction;
import org.eclipse.php.internal.ui.actions.ManageExternalBreakpointAction;
import org.eclipse.php.internal.ui.actions.OpenDeclarationAction;
import org.eclipse.php.internal.ui.actions.OpenFunctionsManualAction;
import org.eclipse.php.internal.ui.actions.RefactorActionGroup;
import org.eclipse.php.internal.ui.actions.ToggleExternalBreakpointAction;
import org.eclipse.php.internal.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.internal.ui.editor.LocalStorageModelProvider;
import org.eclipse.php.internal.ui.editor.PHPPairMatcher;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.internal.ui.editor.hover.SourceViewerInformationControl;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.outline.PHPContentOutlineConfiguration;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.php.internal.ui.text.PHPWordIterator;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProcessorForPHP;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;

public class PHPStructuredEditor
extends StructuredTextEditor {
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN = "org.eclipse.php.ui.actions.Open";
    private static final String ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION = "org.eclipse.php.ui.actions.OpenFunctionsManualAction";
    private PHPPairMatcher fBracketMatcher = new PHPPairMatcher(BRACKETS);
    private CompositeActionGroup fContextMenuGroup;
    private CompositeActionGroup fActionGroups;
    private boolean isExternal;
    private final List fCursorActions = new ArrayList(5);
    private InformationPresenter fInformationPresenter;
    private IResourceChangeListener fResourceChangeListener;
    private IPreferencesPropagatorListener phpVersionListener;
    private boolean saveActionsEnabled = false;
    private boolean saveActionsIgnoreEmptyLines = false;
    ISelectionChangedListener selectionListener;

    private void initPHPVersionsListener() {
        if (this.phpVersionListener != null) {
            return;
        }
        this.phpVersionListener = new IPreferencesPropagatorListener(){

            public void preferencesEventOccured(PreferencesPropagatorEvent event) {
                try {
                    IDocument doc = PHPStructuredEditor.this.getDocumentProvider().getDocument((Object)PHPStructuredEditor.this.getEditorInput());
                    if (doc instanceof IStructuredDocument) {
                        IStructuredDocumentRegion[] sdRegions;
                        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = sdRegions = ((IStructuredDocument)doc).getStructuredDocumentRegions();
                        int n = sdRegions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStructuredDocumentRegion element = iStructuredDocumentRegionArray[n2];
                            Iterator regionsIt = element.getRegions().iterator();
                            PHPStructuredEditor.this.reparseRegion(doc, regionsIt, element.getStartOffset());
                            ++n2;
                        }
                        PHPStructuredTextViewer textViewer = (PHPStructuredTextViewer)PHPStructuredEditor.this.getTextViewer();
                        textViewer.reconcile();
                    }
                }
                catch (BadLocationException badLocationException) {}
            }

            public IProject getProject() {
                IFile file = PHPStructuredEditor.this.getFile();
                if (file == null) {
                    return null;
                }
                return file.getProject();
            }
        };
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
    }

    private void reparseRegion(IDocument doc, Iterator regionsIt, int offset) throws BadLocationException {
        while (regionsIt.hasNext()) {
            ITextRegion region = (ITextRegion)regionsIt.next();
            if (region instanceof ITextRegionContainer) {
                this.reparseRegion(doc, ((ITextRegionContainer)region).getRegions().iterator(), offset + region.getStart());
            }
            if (!(region instanceof IPhpScriptRegion)) continue;
            IPhpScriptRegion phpRegion = (IPhpScriptRegion)region;
            phpRegion.completeReparse(doc, offset + region.getStart(), region.getLength());
        }
    }

    private void initResourceChangeListener() {
        if (this.fResourceChangeListener != null) {
            return;
        }
        this.fResourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    if (PHPStructuredEditor.this.getSite().getPage().getActiveEditor().equals((Object)PHPStructuredEditor.this) && event.getType() == 1 && event.getDelta() != null) {
                        PHPStructuredEditor.this.refreshViewer();
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener);
    }

    public PHPStructuredEditor() {
        boolean foldingEnabled = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("foldingEnabled");
        SSEUIPlugin.getDefault().getPreferenceStore().setValue("foldingEnabled", foldingEnabled);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(this.createCombinedPreferenceStore());
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
        IPreferenceStore phpEditorPrefs = PHPUiPlugin.getDefault().getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs, phpEditorPrefs});
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof FileStoreEditorInput || input instanceof NonExistingPHPFileEditorInput) {
            this.setDocumentProvider((IDocumentProvider)new TextFileDocumentProvider());
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void dispose() {
        if (this.fContextMenuGroup != null) {
            this.fContextMenuGroup.dispose();
            this.fContextMenuGroup = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.dispose();
            this.fInformationPresenter = null;
        }
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        if (this.phpVersionListener != null) {
            PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
            this.phpVersionListener = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        super.dispose();
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.fContextMenuGroup != null) {
            ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
            this.fContextMenuGroup.setContext(context);
            this.fContextMenuGroup.fillContextMenu(menu);
            this.fContextMenuGroup.setContext(null);
        }
    }

    protected void addContextMenuActions(IMenuManager menu) {
        super.addContextMenuActions(menu);
        if (this.getSourceViewer().isEditable()) {
            menu.appendToGroup("group.edit", (IContributionItem)new Separator("group.open"));
            IAction action = this.getAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN);
            if (action != null) {
                menu.appendToGroup("group.open", action);
            }
            if ((action = this.getAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION)) != null) {
                menu.appendToGroup("group.open", action);
            }
            if ((action = this.getAction("org.eclipse.php.ui.actions.OpenDeclaration")) != null) {
                menu.appendToGroup("group.open", action);
            }
        }
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        Object action = new SmartLineStartAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = new SmartLineStartAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        action = new SmartLineEndAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.goto.lineEnd", (IAction)action);
        action = new SmartLineEndAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.select.lineEnd", (IAction)action);
        action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = PHPUIMessages.getResourceBundle();
        this.getSourceViewer();
        this.getSourceViewerConfiguration();
        Object action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.eclipse.php.ui.editor.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        action = new OpenFunctionsManualAction(resourceBundle, this);
        action.setActionDefinitionId("org.eclipse.php.ui.edit.OpenFunctionsManualAction");
        this.setAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION, (IAction)action);
        this.markAsCursorDependentAction(ORG_ECLIPSE_PHP_UI_ACTIONS_OPEN_FUNCTIONS_MANUAL_ACTION, true);
        action = new OpenDeclarationAction(resourceBundle, this);
        action.setActionDefinitionId("org.eclipse.php.ui.edit.text.OpenDeclaration");
        this.setAction("org.eclipse.php.ui.actions.OpenDeclaration", (IAction)action);
        this.markAsCursorDependentAction("org.eclipse.php.ui.actions.OpenDeclaration", true);
        Object resAction = new TextOperationAction(PHPUIMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(PHPUIMessages.getBundleForConstructedKeys(), "ShowPHPDoc.", (TextOperationAction)resAction);
        resAction.setActionDefinitionId("org.eclipse.php.ui.edit.text.show.phpdoc");
        this.setAction("ShowPHPDoc", (IAction)resAction);
        resAction = new TextOperationAction(PHPUIMessages.getBundleForConstructedKeys(), "ShowOutline.", (ITextEditor)this, 22);
        resAction.setActionDefinitionId("org.eclipse.pdt.ui.edit.text.php.show.outline");
        this.setAction("org.eclipse.php.ui.edit.text.show.outline", (IAction)resAction);
        if (this.isExternal) {
            action = new ToggleExternalBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.toggle", (IAction)action);
            action = new ManageExternalBreakpointAction((ITextEditor)this, this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.manage", (IAction)action);
            action = new EditExternalBreakpointAction((ITextEditor)this, this.getVerticalRuler());
            this.setAction("org.eclipse.wst.sse.ui.breakpoints.edit", (IAction)action);
            this.setAction("RulerDoubleClick", (IAction)new ToggleExternalBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler(), null));
        }
        RefactorActionGroup rg = new RefactorActionGroup(this, "group.edit");
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{rg});
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{rg});
    }

    public ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(PHPUIMessages.getString("GotoMatchingBracket_error_invalidSelection"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (PHPStructuredEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(PHPUIMessages.getString("GotoMatchingBracket_error_noMatchingBracket"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(PHPUIMessages.getString("GotoMatchingBracket_error_bracketOutsideSelectedElement"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return PHPStructuredEditor.isBracket(document.getChar(offset - 1)) && PHPStructuredEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = PHPStructuredEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new IPerspectiveListener2(){

            /*
             * Unable to fully structure code
             */
            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
                if (changeId == "editorClose" && partRef.getPart(false) == PHPStructuredEditor.this.getEditorPart()) {
                    file = PHPStructuredEditor.this.getFile();
                    if (file != null) {
                        externalRegistry = ExternalFilesRegistry.getInstance();
                        if (file.exists()) {
                            proj = file.getProject();
                            try {
                                if (proj.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature")) {
                                    PHPWorkspaceModelManager.getInstance().getModelForProject(proj).removeFileFromModel(file);
                                }
                                if (PHPWorkspaceModelManager.getInstance().getModelForProject(proj) == null) ** GOTO lbl30
                                job = new WorkspaceJob(""){

                                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                        PHPWorkspaceModelManager.getInstance().addFileToModel(file);
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                                job.schedule();
                            }
                            catch (CoreException ce) {
                                Logger.logException(ce);
                                return;
                            }
                        } else {
                            model = PHPStructuredEditor.this.getModel();
                            if (model != null && externalRegistry.isEntryExist(fileName = new Path(model.getBaseLocation()).toOSString())) {
                                existingEditors = null;
                                activePage = (WorkbenchPage)PHPStructuredEditor.this.getSite().getWorkbenchWindow().getActivePage();
                                if (activePage != null) {
                                    existingEditors = activePage.getEditorManager().findEditors(PHPStructuredEditor.this.getEditorInput(), null, 1);
                                }
                                if (existingEditors == null || existingEditors.length == 1) {
                                    fileWrapper = ExternalFilesRegistry.getInstance().getFileEntry(fileName);
                                    job = new WorkspaceJob(""){

                                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                            PHPWorkspaceModelManager.getInstance().removeFileFromModel(fileWrapper);
                                            externalRegistry.removeFileEntry(fileName);
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                                    job.schedule();
                                }
                            }
                        }
                    }
lbl30:
                    // 10 sources

                    PHPStructuredEditor.this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
                }
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        });
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 20, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        StyledText styledText = this.getTextViewer().getTextWidget();
        styledText.getContent().addTextChangeListener(new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
            }

            public void textChanged(TextChangedEvent event) {
            }

            public void textSet(TextChangedEvent event) {
                PHPStructuredEditor.this.refreshViewer();
            }
        });
        this.initResourceChangeListener();
    }

    private void refreshViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StructuredTextViewer viewer = PHPStructuredEditor.this.getTextViewer();
                if (viewer != null) {
                    viewer.getTextWidget().redraw();
                }
            }
        });
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IFile resource = null;
        IPath externalPath = null;
        this.isExternal = false;
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            resource = fileInput.getFile();
            IProject proj = resource.getProject();
            if (proj.isAccessible() && proj.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature")) {
                PHPWorkspaceModelManager.getInstance().getModelForProject(proj, true);
            }
        } else if (input instanceof IStorageEditorInput) {
            IStorageEditorInput editorInput = (IStorageEditorInput)input;
            IStorage storage = editorInput.getStorage();
            if (storage instanceof ZipEntryStorage) {
                resource = ((ZipEntryStorage)storage).getProject();
            } else if (storage instanceof LocalFileStorage && ((LocalFileStorage)storage).getProject() != null) {
                resource = ((LocalFileStorage)storage).getProject();
            } else {
                externalPath = storage.getFullPath();
                resource = ExternalFileWrapper.createFile((String)externalPath.toOSString());
            }
        } else if (input instanceof IURIEditorInput || input instanceof NonExistingPHPFileEditorInput) {
            externalPath = input instanceof NonExistingPHPFileEditorInput ? ((NonExistingPHPFileEditorInput)input).getPath() : URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
            resource = ExternalFileWrapper.createFile((String)externalPath.toOSString());
        }
        if (resource instanceof IFile) {
            if (PHPModelUtil.isPhpFile((IFile)resource)) {
                IEditorInput oldInput;
                if (externalPath != null && resource instanceof ExternalFileWrapper) {
                    ExternalFilesRegistry.getInstance().addFileEntry(externalPath.toOSString(), (IFile)((ExternalFileWrapper)resource));
                    this.isExternal = true;
                }
                if ((oldInput = this.getEditorInput()) != null && oldInput instanceof IStorageEditorInput) {
                    String storagePath = ((IStorageEditorInput)oldInput).getStorage().getFullPath().toOSString();
                    ExternalFilesRegistry.getInstance().removeFileEntry(storagePath);
                }
                PhpSourceParser.editFile.set(resource);
                super.doSetInput(input);
                this.initPHPVersionsListener();
            } else {
                super.doSetInput(input);
            }
        } else {
            super.doSetInput(input);
        }
        ImageDescriptor imageDescriptor = input.getImageDescriptor();
        if (imageDescriptor != null) {
            this.setTitleImage(JFaceResources.getResources().createImageWithDefault(imageDescriptor));
        }
    }

    public Object getAdapter(Class required) {
        Object adapter = super.getAdapter(required);
        if (adapter instanceof ConfigurableContentOutlinePage && IContentOutlinePage.class.equals((Object)required)) {
            final ConfigurableContentOutlinePage outlinePage = (ConfigurableContentOutlinePage)adapter;
            PHPContentOutlineConfiguration.DoubleClickListener doubleClickListener = ((PHPContentOutlineConfiguration)outlinePage.getConfiguration()).getDoubleClickListener();
            if (!doubleClickListener.isEnabled()) {
                outlinePage.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
                doubleClickListener.setEnabled(true);
            }
            if (this.selectionListener == null) {
                this.selectionListener = new ISelectionChangedListener(){
                    boolean selecting = false;

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object[] newSelection;
                        Object[] currentSelection;
                        ISelection current;
                        if (!outlinePage.getConfiguration().isLinkedWithEditor(null)) {
                            return;
                        }
                        if (event.getSelection().isEmpty() || this.selecting) {
                            return;
                        }
                        if (PHPStructuredEditor.this.getSourceViewer() != null && PHPStructuredEditor.this.getSourceViewer().getTextWidget() != null && !PHPStructuredEditor.this.getSourceViewer().getTextWidget().isDisposed() && PHPStructuredEditor.this.getSite().getPage().getActivePart() != PHPStructuredEditor.this.getEditorPart() && event.getSelection() instanceof IStructuredSelection && (current = PHPStructuredEditor.this.getSelectionProvider().getSelection()) instanceof IStructuredSelection && !Arrays.equals(currentSelection = ((IStructuredSelection)current).toArray(), newSelection = ((IStructuredSelection)event.getSelection()).toArray()) && newSelection.length > 0) {
                            Object o = newSelection[0];
                            this.selecting = true;
                            if (o instanceof PHPCodeData) {
                                PHPStructuredEditor.this.setSelection((PHPCodeData)o, true);
                            }
                            this.selecting = false;
                        }
                        PHPStructuredEditor.this.clearStatusLine();
                    }
                };
            }
            outlinePage.addSelectionChangedListener(this.selectionListener);
        }
        return adapter;
    }

    protected void clearStatusLine() {
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
    }

    public IFile getFile() {
        if (this.getModel() == null) {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                return ((IFileEditorInput)this.getEditorInput()).getFile();
            }
            return null;
        }
        Path path = new Path(this.getModel().getBaseLocation());
        if (ExternalFilesRegistry.getInstance().isEntryExist(path.toOSString())) {
            return ExternalFilesRegistry.getInstance().getFileEntry(path.toOSString());
        }
        if (path.segmentCount() == 1) {
            return ExternalFileWrapper.createFile((String)path.toOSString());
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
    }

    public PHPFileData getPHPFileData() {
        if (this.getModel() == null) {
            return null;
        }
        return PHPWorkspaceModelManager.getInstance().getModelForFile(this.getModel().getBaseLocation());
    }

    public SourceViewerConfiguration getSourceViwerConfiguration() {
        return super.getSourceViewerConfiguration();
    }

    protected void handleCursorPositionChanged() {
        this.updateCursorDependentActions();
        super.handleCursorPositionChanged();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        try {
            PHPStructuredTextViewerConfiguration configuration;
            ISourceViewer sourceViewer;
            if ("org.eclipse.php.uihoverModifiers".equals(property) || "org.eclipse.php.uihoverModifierMasks".equals(property)) {
                this.updateHoverBehavior();
            }
            if ((sourceViewer = this.getSourceViewer()) != null && (configuration = (PHPStructuredTextViewerConfiguration)this.getSourceViewerConfiguration()) != null) {
                IContentAssistProcessor[] contentAssistProcessors;
                IContentAssistProcessor[] iContentAssistProcessorArray = contentAssistProcessors = configuration.getContentAssistProcessors(sourceViewer, "org.eclipse.php.PHP_DEFAULT");
                int n = contentAssistProcessors.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentAssistProcessor contentAssistProcessor = iContentAssistProcessorArray[n2];
                    if (contentAssistProcessor instanceof IContentAssistProcessorForPHP) {
                        ((IContentAssistProcessorForPHP)contentAssistProcessor).handlePreferenceStoreChanged(event);
                    }
                    ++n2;
                }
                if ("contentAssistAutoinsert".equals(property) || "contentAssistAutoactivation".equals(property) || "contentAssistAutoactivationDelay".equals(property)) {
                    StructuredContentAssistant contentAssistant = (StructuredContentAssistant)configuration.getPHPContentAssistant(sourceViewer);
                    IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
                    contentAssistant.enableAutoInsert(preferenceStore.getBoolean("contentAssistAutoinsert"));
                    contentAssistant.enableAutoActivation(preferenceStore.getBoolean("contentAssistAutoactivation"));
                    contentAssistant.setAutoActivationDelay(preferenceStore.getInt("contentAssistAutoactivationDelay"));
                }
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.php.ui.phpEditorScope"});
    }

    public void markAsCursorDependentAction(String actionId, boolean mark) {
        assert (actionId != null);
        if (mark) {
            if (!this.fCursorActions.contains(actionId)) {
                this.fCursorActions.add(actionId);
            }
        } else {
            this.fCursorActions.remove(actionId);
        }
    }

    public IDocument getDocument() {
        return this.getSourceViewer().getDocument();
    }

    public void setSelection(PHPCodeData element, boolean reveal) {
        if (element != null) {
            IStructuredDocument sDocument;
            IStructuredDocumentRegion sdRegion;
            UserData userData = element.getUserData();
            PHPFileData fileData = this.getPHPFileData();
            if (userData == null || fileData == null || !userData.getFileName().equals(fileData.getUserData().getFileName())) {
                return;
            }
            int start = userData.getStartPosition();
            int length = userData.getEndPosition() - userData.getStartPosition() + 1;
            IDocument document = this.getSourceViewer().getDocument();
            if (document instanceof IStructuredDocument && (sdRegion = (sDocument = (IStructuredDocument)document).getRegionAtCharacterOffset(start)) != null) {
                int sdRegionStart = sdRegion.getStartOffset();
                ITextRegion region = sdRegion.getRegionAtCharacterOffset(start);
                if (region.getType() == "PHP_CONTENT") {
                    IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)region;
                    try {
                        region = phpScriptRegion.getPhpToken(start - sdRegionStart - phpScriptRegion.getStart());
                        String elementName = element.getName();
                        if (element instanceof PHPVariableData) {
                            elementName = "$" + elementName;
                        }
                        while (region.getEnd() != phpScriptRegion.getLength()) {
                            String text = document.get(sdRegionStart + phpScriptRegion.getStart() + region.getStart(), region.getTextLength()).trim().replaceAll("[\"']+", "");
                            if (elementName.equals(text)) {
                                start = sdRegionStart + phpScriptRegion.getStart() + region.getStart();
                                length = region.getTextLength();
                                break;
                            }
                            region = phpScriptRegion.getPhpToken(region.getEnd());
                        }
                    }
                    catch (BadLocationException e) {
                        PHPUiPlugin.log(e);
                    }
                }
            }
            if (!reveal) {
                this.getSourceViewer().setSelectedRange(start, length);
            } else {
                this.selectAndReveal(start, length);
            }
        }
    }

    private void updateAction(String actionId) {
        assert (actionId != null);
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateCursorDependentActions() {
        if (this.fCursorActions != null) {
            Iterator e = this.fCursorActions.iterator();
            while (e.hasNext()) {
                this.updateAction((String)e.next());
            }
        }
    }

    private void updateHoverBehavior() {
        String[] types;
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] stringArray = types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int[] nArray = stateMasks;
                    int n3 = stateMasks.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int stateMask = nArray[n4];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++n4;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++n2;
        }
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new PHPStructuredTextViewer((ITextEditor)this, parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    public IDocumentProvider getDocumentProvider() {
        LocalStorageModelProvider provider;
        if (this.getEditorInput() instanceof LocalFileStorageEditorInput && (provider = LocalStorageModelProvider.getInstance()) != null) {
            return provider;
        }
        return super.getDocumentProvider();
    }

    public void updateSaveActionsState(IProject project) {
        PreferencesSupport prefSupport = new PreferencesSupport("org.eclipse.php.ui", PHPUiPlugin.getDefault().getPreferenceStore());
        String doCleanupPref = prefSupport.getPreferencesValue("cleanup.remove_trailing_whitespaces", null, project);
        String ignoreEmptyPref = prefSupport.getPreferencesValue("cleanup.remove_trailing_whitespaces_ignore_empty", null, project);
        this.saveActionsEnabled = Boolean.parseBoolean(doCleanupPref);
        this.saveActionsIgnoreEmptyLines = Boolean.parseBoolean(ignoreEmptyPref);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.updateSaveActionsState(this.getFile().getProject());
        if (this.saveActionsEnabled) {
            ExtendedRemoveTrailingWhitespaceOperation op = new ExtendedRemoveTrailingWhitespaceOperation(this.saveActionsIgnoreEmptyLines);
            try {
                op.run((IFileBuffer)FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.getDocument()), progressMonitor);
            }
            catch (OperationCanceledException e) {
                Logger.logException(e);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        super.doSave(progressMonitor);
    }

    static /* synthetic */ int access$3(ISourceViewer iSourceViewer, int n) {
        return AbstractTextEditor.widgetOffset2ModelOffset((ISourceViewer)iSourceViewer, (int)n);
    }

    static /* synthetic */ int access$4(ISourceViewer iSourceViewer, int n) {
        return AbstractTextEditor.modelOffset2WidgetOffset((ISourceViewer)iSourceViewer, (int)n);
    }

    class ExtendedRemoveTrailingWhitespaceOperation
    extends RemoveTrailingWhitespaceOperation {
        private boolean fIgnoreEmptyLines;

        public ExtendedRemoveTrailingWhitespaceOperation(boolean ignoreEmptyLines) {
            this.fIgnoreEmptyLines = ignoreEmptyLines;
        }

        protected MultiTextEditWithProgress computeTextEdit(ITextFileBuffer fileBuffer, IProgressMonitor progressMonitor) throws CoreException {
            IDocument document = fileBuffer.getDocument();
            int lineCount = document.getNumberOfLines();
            progressMonitor = Progress.getMonitor((IProgressMonitor)progressMonitor);
            progressMonitor.beginTask(PHPUIMessages.getString("RemoveTrailingWhitespaceOperation_task_generatingChanges"), lineCount);
            try {
                MultiTextEditWithProgress multiEdit = new MultiTextEditWithProgress(PHPUIMessages.getString("RemoveTrailingWhitespaceOperation_task_applyingChanges"));
                int i = 0;
                while (i < lineCount) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IRegion region = document.getLineInformation(i);
                    if (region.getLength() != 0) {
                        int lineStart = region.getOffset();
                        int lineExclusiveEnd = lineStart + region.getLength();
                        int j = lineExclusiveEnd - 1;
                        while (j >= lineStart && Character.isWhitespace(document.getChar(j))) {
                            --j;
                        }
                        if (!this.fIgnoreEmptyLines || ++j != lineStart) {
                            if (j < lineExclusiveEnd) {
                                multiEdit.addChild((TextEdit)new DeleteEdit(j, lineExclusiveEnd - j));
                            }
                            progressMonitor.worked(1);
                        }
                    }
                    ++i;
                }
                MultiTextEditWithProgress multiTextEditWithProgress = multiEdit.getChildrenSize() <= 0 ? null : multiEdit;
                return multiTextEditWithProgress;
            }
            catch (BadLocationException x) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 1, "", (Throwable)x));
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)PHPStructuredEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
                Point p = styledText.getLocationAtOffset(widgetOffset);
                if (p.x > x) {
                    --widgetOffset;
                }
                if (textViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetOffset + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer sourceViewer, IAnnotationHover annotationHover) {
            IVerticalRuler info = PHPStructuredEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            try {
                Object hoverInfo;
                if (annotationHover instanceof IAnnotationHoverExtension) {
                    IAnnotationHoverExtension extension = (IAnnotationHoverExtension)annotationHover;
                    ILineRange hoverLineRange = extension.getHoverLineRange(sourceViewer, line);
                    if (hoverLineRange == null) {
                        return false;
                    }
                    hoverInfo = extension.getHoverInfo(sourceViewer, hoverLineRange, Integer.MAX_VALUE);
                } else {
                    hoverInfo = annotationHover.getHoverInfo(sourceViewer, line);
                }
                IDocument document = sourceViewer.getDocument();
                int offset = document.getLineOffset(line);
                String contentType = TextUtilities.getContentType((IDocument)document, (String)"org.eclipse.php.PHP_DOC", (int)offset, (boolean)true);
                IInformationControlCreator controlCreator = null;
                if ("org.eclipse.jface.text.source.projection.ProjectionAnnotationHover".equals(annotationHover.getClass().getName())) {
                    controlCreator = new IInformationControlCreator(){

                        public IInformationControl createInformationControl(Shell shell) {
                            int shellStyle = 0x14 | PHPStructuredEditor.this.getOrientation();
                            return new SourceViewerInformationControl(shell, shellStyle, 768);
                        }
                    };
                } else if (annotationHover instanceof IInformationProviderExtension2) {
                    controlCreator = ((IInformationProviderExtension2)annotationHover).getInformationPresenterControlCreator();
                } else if (annotationHover instanceof IAnnotationHoverExtension) {
                    controlCreator = ((IAnnotationHoverExtension)annotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
                PHPStructuredEditor.this.fInformationPresenter.setOffset(offset);
                PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                PHPStructuredEditor.this.fInformationPresenter.setMargins(4, 0);
                PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
                PHPStructuredEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            String decoratedMessage;
            IHoverMessageDecorator decorator;
            IRegion hoverRegion;
            int offset;
            block6: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block6;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            if (textHover instanceof IPHPTextHover && (decorator = ((IPHPTextHover)textHover).getMessageDecorator()) != null && (decoratedMessage = decorator.getDecoratedMessage(hoverInfo)) != null && decoratedMessage.length() > 0) {
                hoverInfo = decoratedMessage;
            }
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            PHPStructuredEditor.this.fInformationPresenter.setOffset(offset);
            PHPStructuredEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            PHPStructuredEditor.this.fInformationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)"org.eclipse.php.PHP_DOC", (int)offset, (boolean)true);
            PHPStructuredEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            PHPStructuredEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = PHPStructuredEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(sourceViewer, annotationHover)) {
                return;
            }
            this.fTextOperationAction.run();
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private final IInformationControlCreator fControlCreator;
        private final Object fHoverInfo;
        private final IRegion fHoverRegion;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(PHPStructuredEditor.access$4(PHPStructuredEditor.this.getSourceViewer(), position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(PHPStructuredEditor.access$4(PHPStructuredEditor.this.getSourceViewer(), position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected PHPWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(PHPStructuredEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new PHPWordIterator();
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            IPreferenceStore store = this.getPreferenceStore();
            if (!store.getBoolean("editorSubWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = PHPStructuredEditor.access$3(viewer, viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int next = this.findNextPosition(position);
            if (next != -1) {
                this.setCaretPosition(next);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.following(position)) == -1) continue;
                widget = PHPStructuredEditor.access$4(viewer, position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected PHPWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(PHPStructuredEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new PHPWordIterator();
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            IPreferenceStore store = this.getPreferenceStore();
            if (!store.getBoolean("editorSubWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = PHPStructuredEditor.access$3(viewer, viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int previous = this.findPreviousPosition(position);
            if (previous != -1) {
                this.setCaretPosition(previous);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.preceding(position)) == -1) continue;
                widget = PHPStructuredEditor.access$4(viewer, position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = PHPStructuredEditor.access$4(viewer, position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = PHPStructuredEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = PHPStructuredEditor.access$4(viewer, position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SmartLineEndAction
    extends TextNavigationAction {
        private final boolean fDoSelect;

        public SmartLineEndAction(StyledText textWidget, boolean doSelect) {
            super(textWidget, 0x1000008);
            this.fDoSelect = doSelect;
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            int lineLength;
            ISourceViewer fSourceViewer;
            StyledText st;
            boolean isSmartHomeEndEnabled = true;
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                isSmartHomeEndEnabled = store.getBoolean("useSmartHomeEnd");
            }
            if ((st = (fSourceViewer = PHPStructuredEditor.this.getSourceViewer()).getTextWidget()) == null || st.isDisposed()) {
                return;
            }
            int caretOffset = st.getCaretOffset();
            int lineNumber = st.getLineAtOffset(caretOffset);
            int lineOffset = st.getOffsetAtLine(lineNumber);
            try {
                int caretOffsetInDocument = PHPStructuredEditor.access$3(fSourceViewer, caretOffset);
                lineLength = fSourceViewer.getDocument().getLineInformationOfOffset(caretOffsetInDocument).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int lineEndOffset = lineOffset + lineLength;
            int delta = lineEndOffset - st.getCharCount();
            if (delta > 0) {
                lineEndOffset -= delta;
                lineLength -= delta;
            }
            String line = "";
            if (lineLength > 0) {
                line = st.getText(lineOffset, lineEndOffset - 1);
            }
            int i = lineLength - 1;
            while (i > -1 && Character.isWhitespace(line.charAt(i))) {
                --i;
            }
            ++i;
            Point oldSelection = st.getSelection();
            int newCaretOffset = -1;
            if (isSmartHomeEndEnabled) {
                newCaretOffset = caretOffset - lineOffset == i ? lineEndOffset : lineOffset + i;
            } else if (caretOffset < lineEndOffset) {
                newCaretOffset = lineEndOffset;
            }
            if (newCaretOffset == -1) {
                newCaretOffset = caretOffset;
            } else {
                st.setCaretOffset(newCaretOffset);
            }
            st.setCaretOffset(newCaretOffset);
            if (this.fDoSelect) {
                if (caretOffset < oldSelection.y) {
                    st.setSelection(oldSelection.y, newCaretOffset);
                } else {
                    st.setSelection(oldSelection.x, newCaretOffset);
                }
            } else {
                st.setSelection(newCaretOffset);
            }
            this.fireSelectionChanged(oldSelection);
        }
    }

    protected class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        private final boolean fDoSelect;

        public SmartLineStartAction(StyledText textWidget, boolean doSelect) {
            super((AbstractTextEditor)PHPStructuredEditor.this, textWidget, doSelect);
            this.fDoSelect = doSelect;
        }

        protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
            String type = "__dftl_partition_content_type";
            try {
                type = TextUtilities.getContentType((IDocument)document, (String)"org.eclipse.php.PHP_DEFAULT", (int)offset, (boolean)true);
            }
            catch (BadLocationException badLocationException) {}
            int index = super.getLineStartPosition(document, line, length, offset);
            if (type.equals("org.eclipse.php.PHP_DOC") || type.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT")) {
                if (index < length - 1 && line.charAt(index) == '*' && line.charAt(index + 1) != '/') {
                    while (++index < length && Character.isWhitespace(line.charAt(index))) {
                    }
                }
            } else if (index < length - 1 && line.charAt(index) == '/' && line.charAt(index + 1) == '/') {
                ++index;
                while (++index < length && Character.isWhitespace(line.charAt(index))) {
                }
            }
            return index;
        }

        private IPreferenceStore getPreferenceStore() {
            return PHPUiPlugin.getDefault().getPreferenceStore();
        }

        public void run() {
            int lineLength;
            int caretOffsetInDocument;
            ISourceViewer fSourceViewer;
            StyledText st;
            boolean isSmartHomeEndEnabled = true;
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                isSmartHomeEndEnabled = store.getBoolean("useSmartHomeEnd");
            }
            if ((st = (fSourceViewer = PHPStructuredEditor.this.getSourceViewer()).getTextWidget()) == null || st.isDisposed()) {
                return;
            }
            int caretOffset = st.getCaretOffset();
            int lineNumber = st.getLineAtOffset(caretOffset);
            int lineOffset = st.getOffsetAtLine(lineNumber);
            IDocument document = fSourceViewer.getDocument();
            try {
                caretOffsetInDocument = PHPStructuredEditor.access$3(fSourceViewer, caretOffset);
                lineLength = document.getLineInformationOfOffset(caretOffsetInDocument).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            String line = "";
            if (lineLength > 0) {
                int end = lineOffset + lineLength - 1;
                end = Math.min(end, st.getCharCount() - 1);
                line = st.getText(lineOffset, end);
            }
            int index = this.getLineStartPosition(document, line, lineLength, caretOffsetInDocument);
            Point oldSelection = st.getSelection();
            int newCaretOffset = -1;
            if (isSmartHomeEndEnabled) {
                newCaretOffset = caretOffset - lineOffset == index ? lineOffset : lineOffset + index;
            } else if (caretOffset > lineOffset) {
                newCaretOffset = lineOffset;
            }
            if (newCaretOffset == -1) {
                newCaretOffset = caretOffset;
            } else {
                st.setCaretOffset(newCaretOffset);
            }
            if (this.fDoSelect) {
                if (caretOffset < oldSelection.y) {
                    st.setSelection(oldSelection.y, newCaretOffset);
                } else {
                    st.setSelection(oldSelection.x, newCaretOffset);
                }
            } else {
                st.setSelection(newCaretOffset);
            }
            this.fireSelectionChanged(oldSelection);
        }
    }
}

