/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPDocLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.editor.contentassist.CompletionProposalGroup;
import org.eclipse.php.internal.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class PHPDocContentAssistSupport
extends ContentAssistSupport {
    private static final char TAG_SIGN = '@';
    private char[] autoActivationTriggers;
    private final CompletionProposalGroup phpDocCompletionProposalGroup = new ContentAssistSupport.PHPCompletionProposalGroup();

    protected void initPreferences(String prefKey) {
        super.initPreferences(prefKey);
        if (prefKey == null || "contentAssistAutoactivationTriggersPHPDoc".equals(prefKey)) {
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            this.autoActivationTriggers = preferenceStore.getString("contentAssistAutoactivationTriggersPHPDoc").trim().toCharArray();
        }
    }

    public char[] getAutoactivationTriggers() {
        return this.autoActivationTriggers;
    }

    protected void calcCompletionOption(DOMModelForPHP editorModel, int offset, ITextViewer viewer, boolean explicit) throws BadLocationException {
        boolean haveSpacesAtEnd;
        int startOffset;
        PHPProjectModel projectModel = editorModel.getProjectModel();
        if (projectModel == null) {
            projectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        int selectionLength = ((TextSelection)viewer.getSelectionProvider().getSelection()).getLength();
        IStructuredDocumentRegion sdRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)viewer, (int)offset);
        ITextRegion textRegion = null;
        textRegion = offset == editorModel.getStructuredDocument().getLength() ? sdRegion.getLastRegion() : sdRegion.getRegionAtCharacterOffset(offset);
        if (textRegion == null) {
            return;
        }
        IStructuredDocumentRegion container = sdRegion;
        if (textRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)textRegion;
            textRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (textRegion.getType() == "PHP_OPEN") {
            return;
        }
        if (textRegion.getType() == "PHP_CLOSE") {
            if (sdRegion.getStartOffset(textRegion) == offset) {
                ITextRegion regionBefore = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (regionBefore instanceof IPhpScriptRegion) {
                    textRegion = regionBefore;
                }
            } else {
                return;
            }
        }
        if ((startOffset = container.getStartOffset(textRegion)) == offset) {
            ITextRegion preTextRegion = container.getRegionAtCharacterOffset(offset - 1);
            IStructuredDocumentRegion preSdRegion = null;
            if (preTextRegion != null || (preSdRegion = sdRegion.getPrevious()) != null && (preTextRegion = preSdRegion.getRegionAtCharacterOffset(offset - 1)) != null) {
                preTextRegion.getType();
            }
            startOffset = sdRegion.getStartOffset(textRegion);
        }
        IPhpScriptRegion phpScriptRegion = null;
        String partitionType = null;
        int internalOffset = 0;
        if (textRegion instanceof IPhpScriptRegion) {
            String regionType;
            phpScriptRegion = (IPhpScriptRegion)textRegion;
            internalOffset = offset - container.getStartOffset() - phpScriptRegion.getStart();
            partitionType = phpScriptRegion.getPartition(internalOffset);
            if (!(partitionType != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && partitionType != "org.eclipse.php.PHP_DOC" || (regionType = phpScriptRegion.getPhpToken(internalOffset).getType()) != "PHP_COMMENT_START" && regionType != "PHPDOC_COMMENT_START" || phpScriptRegion.getPhpToken(internalOffset).getStart() != internalOffset)) {
                partitionType = phpScriptRegion.getPartition(internalOffset - 1);
            }
            if (!partitionType.equals("org.eclipse.php.PHP_DOC")) {
                return;
            }
        } else {
            return;
        }
        TextSequence statementText = PHPTextSequenceUtilities.getStatement((int)offset, (IStructuredDocumentRegion)sdRegion, (boolean)false);
        int totalLength = statementText.length();
        int endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)statementText, (int)totalLength);
        int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)statementText, (int)endPosition, (boolean)true);
        String lastWord = statementText.subSequence(startPosition, endPosition).toString();
        boolean bl = haveSpacesAtEnd = totalLength != endPosition;
        if (this.isInPhpDocCompletion(viewer, (CharSequence)statementText, offset, lastWord, selectionLength, haveSpacesAtEnd, explicit)) {
            return;
        }
        PHPFileData fileData = editorModel.getFileData(true);
        if (fileData != null && this.isVariableCompletion(editorModel, fileData, offset, lastWord, selectionLength, haveSpacesAtEnd)) {
            return;
        }
        if (explicit) {
            this.templateProposals = this.getTemplates(viewer, offset);
        }
    }

    private boolean isInPhpDocCompletion(ITextViewer viewer, CharSequence statementText, int offset, String tagName, int selectionLength, boolean hasSpacesAtEnd, boolean explicit) {
        if (hasSpacesAtEnd) {
            return false;
        }
        int startPosition = statementText.length() - tagName.length();
        if (startPosition <= 0 || statementText.charAt(startPosition - 1) != '@') {
            return false;
        }
        --startPosition;
        boolean founeX = false;
        while (startPosition > 0) {
            if (!Character.isWhitespace(statementText.charAt(startPosition - 1))) {
                if (founeX || statementText.charAt(startPosition - 1) != '*') break;
                founeX = true;
            }
            --startPosition;
        }
        CodeData[] tags = PHPDocLanguageModel.getPHPDocTags((String)tagName);
        this.phpDocCompletionProposalGroup.setData(offset, tags, tagName, selectionLength);
        this.completionProposalGroup = this.phpDocCompletionProposalGroup;
        if (explicit) {
            this.templateProposals = this.getTemplates(viewer, offset);
        }
        return true;
    }

    private boolean isVariableCompletion(DOMModelForPHP phpDOMModel, PHPFileData fileData, int offset, String tagName, int selectionLength, boolean haveSpacesAtEnd) {
        if (haveSpacesAtEnd) {
            return false;
        }
        if (tagName.startsWith("$")) {
            CodeData[] contextVariables;
            tagName = tagName.substring(1);
            PHPCodeContext context = ModelSupport.createContext((PHPFileData)fileData, (int)offset);
            PHPProjectModel projectModel = phpDOMModel.getProjectModel();
            String fileName = fileData.getName();
            CodeData[] variables = projectModel.getVariables(fileName, context, tagName, true);
            PHPClassData[] classes = fileData.getClasses();
            boolean mergedData = false;
            PHPClassData[] pHPClassDataArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                PHPClassData element = pHPClassDataArray[n2];
                CodeData rv = this.isInClassBlocks(element, offset);
                if (rv != null) {
                    context = ModelSupport.createContext((CodeData)rv);
                    contextVariables = projectModel.getVariables(fileName, context, tagName, false);
                    variables = this.mergeCodeData(variables, contextVariables);
                    mergedData = true;
                    break;
                }
                ++n2;
            }
            if (!mergedData) {
                PHPFunctionData[] functions;
                PHPFunctionData[] pHPFunctionDataArray = functions = fileData.getFunctions();
                int n3 = functions.length;
                n = 0;
                while (n < n3) {
                    PHPFunctionData element = pHPFunctionDataArray[n];
                    if (this.isInBlock((PHPCodeData)element, offset)) {
                        context = ModelSupport.createContext((CodeData)element);
                        contextVariables = projectModel.getVariables(fileName, context, tagName, false);
                        variables = this.mergeCodeData(variables, contextVariables);
                        break;
                    }
                    ++n;
                }
            }
            this.completionProposalGroup = this.phpCompletionProposalGroup;
            this.completionProposalGroup.setData(offset, variables, tagName, selectionLength);
            return true;
        }
        return false;
    }

    private CodeData isInClassBlocks(PHPClassData data, int position) {
        PHPFunctionData[] functions;
        if (this.isInBlock((PHPCodeData)data, position)) {
            return data;
        }
        PHPFunctionData[] pHPFunctionDataArray = functions = data.getFunctions();
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPFunctionData element = pHPFunctionDataArray[n2];
            if (this.isInBlock((PHPCodeData)element, position)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private CodeData[] mergeCodeData(CodeData[] codeDataArr1, CodeData[] codeDataArr2) {
        CodeData[] merged = new CodeData[codeDataArr1.length + codeDataArr2.length];
        System.arraycopy(codeDataArr1, 0, merged, 0, codeDataArr1.length);
        System.arraycopy(codeDataArr2, 0, merged, codeDataArr1.length, codeDataArr2.length);
        return merged;
    }

    private boolean isInBlock(PHPCodeData data, int position) {
        return data.getDocBlock() != null ? data.getDocBlock().containsPosition(position) : false;
    }

    protected String getTemplateContext() {
        return "phpdoc";
    }
}

