/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.openType.OpenPhpElementDialog;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class PHPCodeHyperLink
implements IHyperlink {
    private IRegion fRegion;
    private CodeData[] codeDatas;

    public PHPCodeHyperLink(IRegion region, CodeData[] codeDatas) {
        this.fRegion = region;
        this.codeDatas = codeDatas;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IEditorPart part;
        if (this.codeDatas == null) {
            return;
        }
        CodeData codeData = null;
        this.codeDatas[0].getName();
        if (this.codeDatas.length > 1) {
            OpenPhpElementDialog dialog = new OpenPhpElementDialog(Display.getDefault().getActiveShell());
            dialog.getFilter().setSelectClasses(false);
            dialog.getFilter().setSelectFunctions(false);
            dialog.getFilter().setSelectConstants(false);
            if (this.codeDatas[0] instanceof PHPClassData) {
                dialog.getFilter().setSelectClasses(true);
            } else if (this.codeDatas[0] instanceof PHPConstantData) {
                dialog.getFilter().setSelectConstants(true);
            } else if (this.codeDatas[0] instanceof PHPFunctionData) {
                dialog.getFilter().setSelectFunctions(true);
            } else if (this.codeDatas[0] instanceof PHPClassVarData) {
                codeData = this.codeDatas[0];
            }
            if (codeData == null) {
                dialog.setInitialElements(this.codeDatas);
                dialog.setInitFilterText(this.codeDatas[0].getName());
                if (dialog.open() == 1) {
                    return;
                }
                codeData = dialog.getSelectedElement();
            }
        } else {
            codeData = this.codeDatas[0];
        }
        if ((part = EditorUtility.isOpenInEditor(codeData)) != null) {
            IWorkbenchPage page = PHPUiPlugin.getActivePage();
            if (page != null) {
                page.bringToTop((IWorkbenchPart)part);
            }
            EditorUtility.revealInEditor(part, (PHPCodeData)codeData);
        } else {
            try {
                part = EditorUtility.openInEditor(codeData);
                EditorUtility.revealInEditor(part, (PHPCodeData)codeData);
            }
            catch (PartInitException e) {
                Logger.logException(e);
            }
        }
    }
}

