/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates.resolver;

import java.util.ArrayList;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateContext;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PhpTemplateClassResolver
extends TemplateVariableResolver {
    private static final String DEFAULT_VAR = "Object";

    public PhpTemplateClassResolver() {
        super("class", PHPUIMessages.getString("PhpTemplateClassResolver.2"));
    }

    protected String[] resolveAll(TemplateContext context) {
        ArrayList<String> classNames = new ArrayList<String>();
        PhpTemplateContext phpTemplateContext = (PhpTemplateContext)context;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager == null) {
            return new String[]{DEFAULT_VAR};
        }
        IStructuredModel structuredModel = modelManager.getExistingModelForRead(phpTemplateContext.getDocument());
        if (structuredModel == null) {
            return new String[]{DEFAULT_VAR};
        }
        try {
            DOMModelForPHP phpDOMModel = (DOMModelForPHP)structuredModel;
            CodeData[] codeDatas = phpDOMModel.getProjectModel().getClasses();
            int i = 0;
            while (i < codeDatas.length) {
                CodeData codeData = codeDatas[i];
                classNames.add(codeData.getName());
                ++i;
            }
        }
        finally {
            structuredModel.releaseFromRead();
        }
        return classNames.toArray(new String[classNames.size()]);
    }
}

