/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.util;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PHPDocBlockSerialezer {
    private static PHPDocBlockSerialezer instance;
    private static final String DOCBLOCK_START = "/**";
    private static final String DOCBLOCK_END = " */";
    private static final String CENTERED_ASTERISK = " * ";
    private static final String RIGHT_ASTERISK = " *";
    private static Pattern pattern;
    private static String lineDelimiter;

    static {
        pattern = Pattern.compile("\n");
        lineDelimiter = "";
    }

    public static PHPDocBlockSerialezer instance() {
        if (instance == null) {
            instance = new PHPDocBlockSerialezer();
        }
        return instance;
    }

    private PHPDocBlockSerialezer() {
    }

    public String createDocBlockText(IStructuredDocument document, PHPDocBlock docBlock, int position, boolean addNewLine) {
        String longDesc;
        if (!lineDelimiter.equals(document.getLineDelimiter())) {
            lineDelimiter = document.getLineDelimiter();
            pattern = Pattern.compile(lineDelimiter);
        }
        String whiteSpaces = this.getPreInertionPointWhiteSpaces((IDocument)document, position);
        String tagsText = this.createTagsText(docBlock, whiteSpaces);
        StringBuffer rv = new StringBuffer();
        if (docBlock.getType() == 0) {
            rv.append(lineDelimiter);
            rv.append(whiteSpaces);
        }
        rv.append(DOCBLOCK_START);
        rv.append(lineDelimiter);
        if (!docBlock.getShortDescription().equals("")) {
            rv.append(whiteSpaces);
            rv.append(CENTERED_ASTERISK);
            rv.append(docBlock.getShortDescription());
            rv.append(lineDelimiter);
            rv.append(whiteSpaces);
            rv.append(RIGHT_ASTERISK);
            rv.append(lineDelimiter);
        }
        if (!(longDesc = docBlock.getLongDescription().replaceAll(pattern.pattern(), String.valueOf(lineDelimiter) + whiteSpaces + CENTERED_ASTERISK)).equals("")) {
            rv.append(whiteSpaces);
            rv.append(CENTERED_ASTERISK);
            rv.append(longDesc);
            rv.append(lineDelimiter);
            rv.append(whiteSpaces);
            rv.append(RIGHT_ASTERISK);
            rv.append(lineDelimiter);
        }
        rv.append(tagsText);
        rv.append(whiteSpaces);
        rv.append(DOCBLOCK_END);
        if (addNewLine) {
            rv.append(lineDelimiter);
            rv.append(whiteSpaces);
        }
        return rv.toString();
    }

    private String createTagsText(PHPDocBlock docBlock, String whiteSpaces) {
        Iterator it = docBlock.getTags();
        String rv = "";
        while (it != null && it.hasNext()) {
            PHPDocTag phpDocTag = (PHPDocTag)it.next();
            rv = String.valueOf(rv) + whiteSpaces + CENTERED_ASTERISK + phpDocTag.toString() + lineDelimiter;
        }
        return rv;
    }

    private String getPreInertionPointWhiteSpaces(IDocument document, int position) {
        try {
            int lineStartOffset;
            IRegion region = document.getLineInformationOfOffset(position);
            int i = lineStartOffset = region.getOffset();
            while (i < position) {
                if (!Character.isWhitespace(document.getChar(i))) break;
                ++i;
            }
            return document.get(lineStartOffset, i - lineStartOffset);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return "";
        }
    }
}

