/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.html.internal.validation.HTMLValidationReporter;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Text;

public class PHPValidator
implements IValidator,
ISourceValidator {
    private IDocument document;
    private IFile file;

    public void connect(IDocument document) {
        if (document == null) {
            throw new IllegalStateException(PHPUIMessages.getString("PHPValidator.0"));
        }
        this.document = document;
        if (!(document instanceof IStructuredDocument)) {
            throw new IllegalStateException(PHPUIMessages.getString("PHPValidator.1"));
        }
        if (FileBufferModelManager.getInstance().calculateId(document) == null) {
            this.document = null;
            return;
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)document);
        if (model == null) {
            throw new IllegalStateException(PHPUIMessages.getString("PHPValidator.2"));
        }
        try {
            assert (model instanceof DOMModelForPHP);
            DOMModelForPHP phpDomModel = (DOMModelForPHP)model;
            this.file = phpDomModel.getIFile();
            if (this.file == null) {
                throw new IllegalStateException(String.valueOf(PHPUIMessages.getString("PHPValidator.3")) + phpDomModel.getBaseLocation());
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void disconnect(IDocument document) {
        this.document = null;
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        PHPFileData fileData;
        if (helper == null || this.document == null || this.file == null) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(this.file.getProject());
        if (ExternalFilesRegistry.getInstance().isEntryExist(this.file)) {
            projectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        if (projectModel == null) {
            return;
        }
        projectModel.fileWasChanged(this.file, this.document);
        String fileName = "";
        IPath filePath = this.file.getFullPath();
        if (filePath != null) {
            fileName = filePath.toString();
        }
        if ((fileData = projectModel.getFileData(this.file.getFullPath().toString())) == null && (fileData = projectModel.getFileData(this.file.getFullPath().toOSString())) == null) {
            return;
        }
        IPHPMarker[] markers = fileData.getMarkers();
        if (markers == null) {
            return;
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
        if (model == null) {
            return;
        }
        try {
            IndexedRegion ir = this.getNode(dirtyRegion, model);
            if (ir instanceof INodeNotifier) {
                HTMLValidationAdapterFactory factory = HTMLValidationAdapterFactory.getInstance();
                ValidationAdapter adapter = (ValidationAdapter)factory.adapt((INodeNotifier)ir);
                if (adapter == null) {
                    return;
                }
                if (reporter != null) {
                    HTMLValidationReporter validationReporter = null;
                    validationReporter = this.getReporter(reporter, this.file, (IDOMModel)model);
                    validationReporter.clear();
                    adapter.setReporter((ValidationReporter)validationReporter);
                    (new String[1])[0] = fileName;
                    IPHPMarker[] iPHPMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPHPMarker marker = iPHPMarkerArray[n2];
                        if (!marker.getType().equals("TASK")) {
                            UserData userData = marker.getUserData();
                            String description = marker.getDescription();
                            int offset = userData.getStartPosition();
                            int length = userData.getEndPosition() - offset;
                            ValidationMessage message = new ValidationMessage(description, offset, length, 1);
                            validationReporter.report(message);
                        }
                        ++n2;
                    }
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected HTMLValidationReporter getReporter(IReporter reporter, IFile file, IDOMModel model) {
        return new HTMLValidationReporter((IValidator)this, reporter, file, (IStructuredModel)model);
    }

    private IndexedRegion getNode(IRegion dirtyRegion, IStructuredModel model) {
        IndexedRegion ir = this.getCoveringNode(dirtyRegion);
        if (ir instanceof Text) {
            while (ir != null && ir instanceof Text) {
                ir = model.getIndexedRegion(ir.getEndOffset());
            }
        }
        return ir;
    }

    private IndexedRegion getCoveringNode(IRegion dirtyRegion) {
        IndexedRegion largestRegion = null;
        if (this.document instanceof IStructuredDocument) {
            IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            try {
                if (sModel != null) {
                    IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.document).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
                    largestRegion = this.getLargest(regions);
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        return largestRegion;
    }

    protected IndexedRegion getLargest(IStructuredDocumentRegion[] sdRegions) {
        if (sdRegions == null || sdRegions.length == 0) {
            return null;
        }
        IndexedRegion currentLargest = this.getCorrespondingNode(sdRegions[0]);
        int i = 0;
        while (i < sdRegions.length) {
            if (!sdRegions[i].isDeleted()) {
                IndexedRegion corresponding = this.getCorrespondingNode(sdRegions[i]);
                if (currentLargest instanceof Text) {
                    currentLargest = corresponding;
                }
                if (corresponding != null && !(corresponding instanceof Text) && corresponding.getStartOffset() <= currentLargest.getStartOffset() && corresponding.getEndOffset() >= currentLargest.getEndOffset()) {
                    currentLargest = corresponding;
                }
            }
            ++i;
        }
        return currentLargest;
    }

    protected IndexedRegion getCorrespondingNode(IStructuredDocumentRegion sdRegion) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
        IndexedRegion indexedRegion = null;
        try {
            if (sModel != null) {
                indexedRegion = sModel.getIndexedRegion(sdRegion.getStart());
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return indexedRegion;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }

    protected boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }
}

