/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.dnd.PHPViewerDropAdapter;
import org.eclipse.php.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;

class FileTransferDropAdapter
extends PHPViewerDropAdapter
implements TransferDropTargetListener {
    FileTransferDropAdapter(AbstractTreeViewer viewer) {
        super((StructuredViewer)viewer, 24);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        boolean isPHPFolder = target instanceof IFolder;
        boolean isPHPProject = target instanceof PHPProjectModel;
        boolean isContainer = target instanceof IContainer;
        if (!(isPHPFolder || isPHPProject || isContainer)) {
            return;
        }
        if (isContainer) {
            IContainer container = (IContainer)target;
            if (container.isAccessible() && !container.isReadOnly()) {
                event.detail = 1;
            }
        } else if (!PHPModelUtil.isReadOnly((Object)target)) {
            event.detail = 1;
        }
    }

    public void drop(Object dropTarget, final DropTargetEvent event) {
        int operation = event.detail;
        event.detail = 0;
        final Object data = event.data;
        if (data == null || !(data instanceof String[]) || operation != 1) {
            return;
        }
        final IContainer target = this.getActualTarget(dropTarget);
        if (target == null) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                FileTransferDropAdapter.this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(FileTransferDropAdapter.this.getShell()).copyFiles((String[])data, target);
                event.detail = 1;
            }
        });
    }

    private IContainer getActualTarget(Object dropTarget) {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof PHPCodeData) {
            return PHPModelUtil.getResource((Object)((PHPCodeData)dropTarget)).getParent();
        }
        return null;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

