/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.explorer.ExplorerContentProvider;
import org.eclipse.php.internal.ui.explorer.ExplorerPart;
import org.eclipse.php.internal.ui.explorer.IMultiElementTreeContentProvider;
import org.eclipse.php.internal.ui.util.TreePath;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetAwareContentProvider
extends ExplorerContentProvider
implements IMultiElementTreeContentProvider {
    private WorkingSetModel fWorkingSetModel;
    private IPropertyChangeListener fListener;

    public WorkingSetAwareContentProvider(ExplorerPart part, boolean provideMembers, WorkingSetModel model) {
        super(part, provideMembers);
        this.fWorkingSetModel = model;
        this.fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetAwareContentProvider.this.workingSetModelChanged(event);
            }
        };
        this.fWorkingSetModel.addPropertyChangeListener(this.fListener);
    }

    public void dispose() {
        this.fWorkingSetModel.removePropertyChangeListener(this.fListener);
        super.dispose();
    }

    public boolean hasChildrenInternal(Object element) {
        if (element instanceof IWorkingSet) {
            return true;
        }
        return super.hasChildrenInternal(element);
    }

    public Object[] getChildrenInternal(Object element) {
        if (element instanceof WorkingSetModel) {
            Assert.isTrue((this.fWorkingSetModel == element ? 1 : 0) != 0);
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        Object[] children = element instanceof IWorkingSet ? this.filterClosedElements(this.fWorkingSetModel.getChildren((IWorkingSet)element)) : super.getChildrenInternal(element);
        return children;
    }

    private Object[] filterClosedElements(Object[] children) {
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            IProject project;
            Object element = children[i];
            boolean add = false;
            if (element instanceof IProject) {
                add = true;
            } else if (element instanceof IResource) {
                project = ((IResource)element).getProject();
                add = project == null || project.isOpen();
            } else if (element instanceof PHPProjectModel) {
                add = true;
            } else if (element instanceof PHPCodeData) {
                project = this.getProject((PHPCodeData)element);
                boolean bl = add = project == null || project.isOpen();
            }
            if (add) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray();
    }

    private IProject getProject(PHPCodeData element) {
        if (element == null) {
            return null;
        }
        IResource resource = PHPModelUtil.getResource((Object)element);
        if (resource == null) {
            return null;
        }
        return resource.getProject();
    }

    public TreePath[] getTreePaths(Object element) {
        if (element instanceof IWorkingSet) {
            TreePath path = new TreePath(new Object[]{element});
            return new TreePath[]{path};
        }
        List modelParents = this.getModelPath(element);
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < modelParents.size()) {
            result.addAll(this.getTreePaths(modelParents, i));
            ++i;
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private List getModelPath(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(element);
        Object parent = super.getParent(element);
        Object input = this.getViewerInput();
        while (parent != null && !parent.equals(input) && !(parent instanceof PHPWorkspaceModelManager)) {
            result.add(parent);
            parent = super.getParent(parent);
        }
        Collections.reverse(result);
        return result;
    }

    private List getTreePaths(List modelParents, int index) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Object input = this.getViewerInput();
        Object element = modelParents.get(index);
        Object[] parents = this.fWorkingSetModel.getAllParents(element);
        int i = 0;
        while (i < parents.length) {
            ArrayList<Object> chain = new ArrayList<Object>();
            if (!parents[i].equals(input)) {
                chain.add(parents[i]);
            }
            int m = index;
            while (m < modelParents.size()) {
                chain.add(modelParents.get(m));
                ++m;
            }
            result.add(new TreePath(chain.toArray()));
            ++i;
        }
        return result;
    }

    public Object internalGetParent(Object child) {
        Object[] parents = this.fWorkingSetModel.getAllParents(child);
        if (parents.length == 0) {
            return super.internalGetParent(child);
        }
        Object first = parents[0];
        if (first instanceof IWorkingSet && "org.eclipse.php.ui.HistoryWorkingSet".equals(((IWorkingSet)first).getId())) {
            if (parents.length > 1) {
                return parents[1];
            }
            return super.internalGetParent(child);
        }
        return first;
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
        Object parent;
        if (PHPWorkspaceModelManager.getInstance().equals(affectedElement)) {
            toRefresh.remove(affectedElement);
            toRefresh.add(this.fWorkingSetModel);
        } else if (relation == 2 && (parent = this.internalGetParent(affectedElement)) != null) {
            toRefresh.addAll((Collection)Arrays.asList(this.fWorkingSetModel.getAllParents(parent)));
        }
    }

    private void workingSetModelChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        Object newValue = event.getNewValue();
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        if ("workingSetModelChanged".equals(property)) {
            toRefresh.add(this.fWorkingSetModel);
        } else if ("workingSetContentChange".equals(property)) {
            toRefresh.add(newValue);
        } else if ("workingSetNameChange".equals(property)) {
            toRefresh.add(newValue);
        }
        this.postRefresh(toRefresh, true);
    }
}

