/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryPHP;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterPHP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderPHP
implements IStructuredTextFoldingProvider,
IProjectionListener,
ITextInputListener,
ModelListener,
IPropertyChangeListener {
    private IDocument fDocument;
    private ProjectionViewer fViewer;
    private boolean fProjectionNeedsToBeEnabled = false;
    private static final int MAX_CHILDREN = 10;
    private static final int MAX_SIBLINGS = 1000;

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.projectionDisabled();
        this.fDocument = this.fViewer.getDocument();
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            ProjectionModelNodeAdapterFactoryHTML factory2;
            ProjectionModelNodeAdapterFactoryPHP factory = this.getAdapterFactoryPHP(true);
            if (factory != null) {
                factory.addProjectionViewer(this.fViewer);
            }
            if ((factory2 = this.getAdapterFactoryHTML(true)) != null) {
                factory2.addProjectionViewer(this.fViewer);
            }
            this.addAllAdapters();
        }
        this.fProjectionNeedsToBeEnabled = false;
    }

    public void install(ProjectionViewer viewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
        this.fViewer.addTextInputListener((ITextInputListener)this);
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
        this.enablePropertyListener();
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    public void projectionDisabled() {
        ProjectionModelNodeAdapterFactoryHTML factory2;
        ProjectionModelNodeAdapterFactoryPHP factory = this.getAdapterFactoryPHP(false);
        if (factory != null) {
            factory.removeProjectionViewer(this.fViewer);
        }
        if ((factory2 = this.getAdapterFactoryHTML(false)) != null) {
            factory2.removeProjectionViewer(this.fViewer);
        }
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            this.fViewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.removeAllAdapters();
        this.fDocument = null;
        this.fProjectionNeedsToBeEnabled = false;
    }

    private void disablePropertyListener() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void projectionEnabled() {
        this.initialize();
    }

    private void enablePropertyListener() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void removeAdapterFromNodeAndChildren(Node node, int level) {
        if (node instanceof INodeNotifier) {
            INodeAdapter adapter2;
            INodeNotifier notifier = (INodeNotifier)node;
            INodeAdapter adapter = notifier.getExistingAdapter(ProjectionModelNodeAdapterPHP.class);
            if (adapter != null) {
                notifier.removeAdapter(adapter);
            }
            if ((adapter2 = notifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class)) != null) {
                notifier.removeAdapter(adapter2);
            }
            Node nextChild = node.getFirstChild();
            while (nextChild != null) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.removeAdapterFromNodeAndChildren(childNode, level + 1);
            }
        }
    }

    private void removeAllAdapters() {
        if (this.fDocument != null) {
            IStructuredModel sModel = null;
            try {
                IndexedRegion startNode;
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null && (startNode = sModel.getIndexedRegion(0)) instanceof Node) {
                    Node nextSibling = (Node)startNode;
                    while (nextSibling != null) {
                        Node currentNode = nextSibling;
                        nextSibling = currentNode.getNextSibling();
                        this.removeAdapterFromNodeAndChildren(currentNode, 0);
                    }
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (this.fDocument != null && this.fDocument != newInput) {
            this.projectionDisabled();
            this.fProjectionNeedsToBeEnabled = true;
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.fProjectionNeedsToBeEnabled && this.fDocument == null && newInput != null) {
            this.projectionEnabled();
            this.fProjectionNeedsToBeEnabled = false;
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer.removeTextInputListener((ITextInputListener)this);
            this.fViewer = null;
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
            this.disablePropertyListener();
        }
    }

    public void fileDataChanged(PHPFileData fileData) {
        if (this.fDocument == null) {
            return;
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        assert (model instanceof DOMModelForPHP) : PHPUIMessages.getString("StructuredTextFoldingProviderPHP.0");
        try {
            IDOMDocument document;
            INodeAdapter adapterFor;
            DOMModelForPHP viewerModel = (DOMModelForPHP)model;
            if (viewerModel != null && viewerModel.getFileData() == fileData && (adapterFor = (document = viewerModel.getDocument()).getAdapterFor(ProjectionModelNodeAdapterPHP.class)) != null) {
                assert (adapterFor instanceof ProjectionModelNodeAdapterPHP) : PHPUIMessages.getString("StructuredTextFoldingProviderPHP.1");
                ProjectionModelNodeAdapterPHP phpAdapter = (ProjectionModelNodeAdapterPHP)adapterFor;
                phpAdapter.updateAdapter((Node)document);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData fileData) {
        this.fileDataChanged(fileData);
    }

    public void fileDataRemoved(PHPFileData fileData) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        ProjectionModelNodeAdapterFactoryPHP factory = this.getAdapterFactoryPHP(false);
        if (factory != null && ("foldClasses".equals(property) || "foldClasses".equals(property) || "foldPHPDoc".equals(property))) {
            factory.initializePreference();
            this.initialize();
        }
    }

    private void addAdapterToNodeAndChildrenHTML(Node node, int childLevel) {
        if (node instanceof INodeNotifier && childLevel < 10) {
            INodeNotifier notifier = (INodeNotifier)node;
            ProjectionModelNodeAdapterHTML adapter2 = (ProjectionModelNodeAdapterHTML)notifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class);
            if (adapter2 != null) {
                adapter2.updateAdapter(node);
            } else {
                notifier.getAdapterFor(ProjectionModelNodeAdapterHTML.class);
            }
            int siblingLevel = 0;
            Node nextChild = node.getFirstChild();
            while (nextChild != null && siblingLevel < 1000) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.addAdapterToNodeAndChildrenHTML(childNode, childLevel + 1);
                ++siblingLevel;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllAdapters() {
        System.currentTimeMillis();
        if (this.fDocument == null) return;
        IStructuredModel sModel = null;
        try {
            block9: {
                Node nextSibling;
                int siblingLevel;
                block8: {
                    sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                    if (sModel == null) return;
                    IndexedRegion startNode = sModel.getIndexedRegion(0);
                    if (startNode == null) {
                        assert (sModel instanceof IDOMModel);
                        startNode = ((IDOMModel)sModel).getDocument();
                    }
                    if (!(startNode instanceof Node)) return;
                    siblingLevel = 0;
                    nextSibling = (Node)startNode;
                    this.addAdapterToDocumentPHP(nextSibling.getOwnerDocument());
                    if (!true) break block8;
                    if (nextSibling == null) return;
                    if (siblingLevel >= 1000) break block9;
                }
                do {
                    Node currentNode = nextSibling;
                    nextSibling = currentNode.getNextSibling();
                    this.addAdapterToNodeAndChildrenHTML(currentNode, 0);
                    ++siblingLevel;
                    if (nextSibling == null) return;
                } while (siblingLevel < 1000);
            }
            return;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    private void addAdapterToDocumentPHP(Document document) {
        if (document == null) {
            return;
        }
        INodeNotifier notifier = (INodeNotifier)document;
        ProjectionModelNodeAdapterPHP adapter = (ProjectionModelNodeAdapterPHP)notifier.getExistingAdapter(ProjectionModelNodeAdapterPHP.class);
        if (adapter != null) {
            adapter.updateAdapter(document, this.fViewer);
        } else {
            notifier.getAdapterFor(ProjectionModelNodeAdapterPHP.class);
        }
    }

    private ProjectionModelNodeAdapterFactoryHTML getAdapterFactoryHTML(boolean createIfNeeded) {
        System.currentTimeMillis();
        ProjectionModelNodeAdapterFactoryHTML factory = null;
        if (this.fDocument != null) {
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null) {
                    FactoryRegistry factoryRegistry = sModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterHTML.class) && createIfNeeded) {
                        ProjectionModelNodeAdapterFactoryHTML newFactory = new ProjectionModelNodeAdapterFactoryHTML();
                        factoryRegistry.addFactory((INodeAdapterFactory)newFactory);
                        IDOMModel domModel = (IDOMModel)sModel;
                        IDOMDocument document = domModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)document).getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)newFactory);
                        }
                    }
                    factory = (ProjectionModelNodeAdapterFactoryHTML)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterHTML.class);
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        return factory;
    }

    private ProjectionModelNodeAdapterFactoryPHP getAdapterFactoryPHP(boolean createIfNeeded) {
        System.currentTimeMillis();
        ProjectionModelNodeAdapterFactoryPHP factory = null;
        if (this.fDocument != null) {
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null) {
                    FactoryRegistry factoryRegistry = sModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterPHP.class) && createIfNeeded) {
                        ProjectionModelNodeAdapterFactoryPHP newFactory = new ProjectionModelNodeAdapterFactoryPHP();
                        factoryRegistry.addFactory((INodeAdapterFactory)newFactory);
                        IDOMModel domModel = (IDOMModel)sModel;
                        IDOMDocument document = domModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)document).getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)newFactory);
                        }
                    }
                    factory = (ProjectionModelNodeAdapterFactoryPHP)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterPHP.class);
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        return factory;
    }
}

