/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.php.internal.ui.text.DocumentCharacterIterator;

public final class CaptionedPosition
extends Position
implements IProjectionPosition {
    CaptionedPosition(int offset, int length) {
        super(offset, length);
    }

    public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
        Region preRegion;
        DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
        int prefixEnd = 0;
        int contentStart = this.findFirstContent(sequence, prefixEnd);
        int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
        int captionLine = document.getLineOfOffset(this.offset + contentStart);
        int lastLine = document.getLineOfOffset(this.offset + this.length);
        Assert.isTrue((firstLine <= captionLine ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
        Assert.isTrue((captionLine <= lastLine ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
        if (firstLine < captionLine) {
            int preOffset = document.getLineOffset(firstLine);
            IRegion preEndLineInfo = document.getLineInformation(captionLine);
            int preEnd = preEndLineInfo.getOffset();
            preRegion = new Region(preOffset, preEnd - preOffset);
        } else {
            preRegion = null;
        }
        if (captionLine < lastLine) {
            int postOffset = document.getLineOffset(captionLine + 1);
            Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
            if (preRegion == null) {
                return new IRegion[]{postRegion};
            }
            return new IRegion[]{preRegion, postRegion};
        }
        if (preRegion != null) {
            return new IRegion[]{preRegion};
        }
        return null;
    }

    private int findFirstContent(CharSequence content, int prefixEnd) {
        int lenght = content.length();
        int i = prefixEnd;
        while (i < lenght) {
            if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int computeCaptionOffset(IDocument document) {
        DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
        return this.findFirstContent(sequence, 0);
    }
}

