/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.folding.projection.ElementProjectionAnnotation;
import org.eclipse.php.internal.ui.folding.projection.ProjectionAnnotationModelChanges;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectionViewerInformation {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final ProjectionAnnotationModel fProjectionAnnotationModel;
    private final IDocument fDocument;
    private IDocumentListener fDocumentListener;
    private boolean fIsDocumentChanging = false;
    private List<ProjectionAnnotationModelChanges> fQueuedAnnotationChanges;

    public ProjectionViewerInformation(ProjectionViewer viewer) {
        this.fDocument = viewer.getDocument();
        this.fProjectionAnnotationModel = viewer.getProjectionAnnotationModel();
    }

    IDocument getDocument() {
        return this.fDocument;
    }

    private List<ProjectionAnnotationModelChanges> getQueuedAnnotationChanges() {
        if (this.fQueuedAnnotationChanges == null) {
            this.fQueuedAnnotationChanges = new LinkedList<ProjectionAnnotationModelChanges>();
        }
        return this.fQueuedAnnotationChanges;
    }

    void setIsDocumentChanging(boolean changing) {
        this.fIsDocumentChanging = changing;
    }

    boolean isDocumentChanging() {
        return this.fIsDocumentChanging;
    }

    void applyAnnotationModelChanges() {
        List<ProjectionAnnotationModelChanges> queuedChanges = this.getQueuedAnnotationChanges();
        block2: while (!queuedChanges.isEmpty()) {
            ProjectionAnnotationModelChanges changes = queuedChanges.remove(0);
            try {
                HashSet<Position> collapsedPositions = new HashSet<Position>();
                HashMap<Position, ProjectionAnnotation> positionAnnotations = new HashMap<Position, ProjectionAnnotation>();
                Iterator i = this.fProjectionAnnotationModel.getAnnotationIterator();
                while (i.hasNext()) {
                    ProjectionAnnotation existingAnnotation = (ProjectionAnnotation)i.next();
                    Position position = this.fProjectionAnnotationModel.getPosition((Annotation)existingAnnotation);
                    if (existingAnnotation.isCollapsed()) {
                        collapsedPositions.add(position);
                    }
                    positionAnnotations.put(position, existingAnnotation);
                }
                Annotation[] deletions = changes.getDeletions();
                if (deletions == null) {
                    deletions = EMPTY_ANNOTATIONS;
                }
                HashSet<Position> shouldNotDelete = new HashSet<Position>(deletions.length);
                Annotation[] annotationArray = deletions;
                int n = deletions.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation deletion = annotationArray[n2];
                    Position position = this.fProjectionAnnotationModel.getPosition(deletion);
                    if (collapsedPositions.contains(position)) {
                        shouldNotDelete.add(position);
                    }
                    ++n2;
                }
                Map additions = changes.getAdditions();
                for (Map.Entry addition : additions.entrySet()) {
                    Position position = (Position)addition.getValue();
                    ProjectionAnnotation newAnnotation = (ProjectionAnnotation)addition.getKey();
                    if (!shouldNotDelete.contains(position)) {
                        Position position2 = this.fProjectionAnnotationModel.getPosition((Annotation)newAnnotation);
                        if (position2 != null) continue;
                        this.fProjectionAnnotationModel.addAnnotation((Annotation)newAnnotation, position);
                        continue;
                    }
                    ProjectionAnnotation existingAnnotation = (ProjectionAnnotation)positionAnnotations.get(position);
                    if (existingAnnotation.isCollapsed()) continue;
                    newAnnotation.markExpanded();
                    HashMap<ProjectionAnnotation, Position> annotationAddition = new HashMap<ProjectionAnnotation, Position>(1);
                    annotationAddition.put(newAnnotation, position);
                    this.fProjectionAnnotationModel.replaceAnnotations(new Annotation[]{existingAnnotation}, annotationAddition);
                }
                Map modifications = changes.getModifications();
                if (modifications == null) continue;
                for (Map.Entry entry : modifications.entrySet()) {
                    ElementProjectionAnnotation modifiedAnnotation = (ElementProjectionAnnotation)((Object)entry.getKey());
                    Position modifiedPosition = (Position)entry.getValue();
                    Position position = this.fProjectionAnnotationModel.getPosition((Annotation)modifiedAnnotation);
                    if (position == null) {
                        shouldNotDelete.contains(modifiedPosition);
                        continue;
                    }
                    if (modifiedPosition.equals((Object)position) || !modifiedAnnotation.sameSize) continue;
                    this.fProjectionAnnotationModel.modifyAnnotationPosition((Annotation)modifiedAnnotation, modifiedPosition);
                    continue block2;
                }
            }
            catch (RuntimeException e) {
                Logger.logException(e);
            }
        }
    }

    private boolean inScript(int offset) {
        ITextRegion phpToken;
        String partitionType;
        int internalOffset;
        IPhpScriptRegion phpScriptRegion;
        block6: {
            IStructuredDocument document = (IStructuredDocument)this.fDocument;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
            ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (textRegion == null) {
                return false;
            }
            IStructuredDocumentRegion container = sdRegion;
            if (textRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)textRegion;
                textRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (!(textRegion instanceof IPhpScriptRegion)) {
                return false;
            }
            phpScriptRegion = (IPhpScriptRegion)textRegion;
            internalOffset = offset - container.getStartOffset() - phpScriptRegion.getStart();
            try {
                partitionType = phpScriptRegion.getPartition(internalOffset);
                if (partitionType != "org.eclipse.php.PHP_DEFAULT") break block6;
                return true;
            }
            catch (BadLocationException e) {
                Logger.logException(e);
                return false;
            }
        }
        return (partitionType == "org.eclipse.php.PHP_DOC" || partitionType == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") && (phpToken = phpScriptRegion.getPhpToken(internalOffset)).getStart() == internalOffset;
    }

    boolean hasChangesQueued() {
        return !this.getQueuedAnnotationChanges().isEmpty();
    }

    public void queueAnnotationModelChanges(ProjectionAnnotationModelChanges newChange) {
        this.getQueuedAnnotationChanges().add(newChange);
        if (!this.isDocumentChanging()) {
            this.applyAnnotationModelChanges();
        }
    }

    public void initialize() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(this);
        }
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fQueuedAnnotationChanges != null) {
            this.fQueuedAnnotationChanges.clear();
            this.fQueuedAnnotationChanges = null;
        }
    }

    private static class DocumentListener
    implements IDocumentListener {
        private final ProjectionViewerInformation fInfo;

        public DocumentListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (this.fInfo.getDocument() == document) {
                this.fInfo.setIsDocumentChanging(true);
            }
        }

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (document instanceof IDocumentExtension && this.fInfo.getDocument() == document) {
                ((IDocumentExtension)document).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener(this.fInfo));
            }
        }
    }

    private static class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        private final ProjectionViewerInformation fInfo;

        public PostDocumentChangedListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void perform(IDocument document, IDocumentListener owner) {
            this.fInfo.applyAnnotationModelChanges();
            this.fInfo.setIsDocumentChanging(false);
        }
    }
}

