/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.functions;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.functions.PHPFunctionsContentProvider;
import org.eclipse.php.internal.ui.functions.PHPFunctionsLabelProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPManualFactory;
import org.eclipse.php.internal.ui.util.StatusBarUpdater;
import org.eclipse.php.internal.ui.workingset.FunctionsViewGroup;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPFunctionsPart
extends ViewPart
implements IMenuListener,
IPartListener {
    private TreeViewer fViewer;
    private PHPFunctionsContentProvider fContentProvider;
    private PHPFunctionsLabelProvider fLabelProvider;
    private Menu fContextMenu;
    private String fWorkingSetName;
    private ShowFunctionHelpAction showFunctionHelpAction;
    private FunctionsViewGroup actionGroup;
    private boolean shouldRefresh = true;

    public void createPartControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.setProviders();
        this.setUpPopupMenu();
        this.actionGroup = new FunctionsViewGroup(this);
        this.addDoubleClickListener();
        this.addMouseTrackListener();
        this.getSite().getPage().addPartListener((IPartListener)this);
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)new StatusBarUpdater(slManager));
        this.fViewer.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (!PHPFunctionsPart.this.fViewer.getTree().isDisposed() && (PHPFunctionsPart.this.shouldRefresh || PHPFunctionsPart.this.fViewer.getTree().getItems().length == 0)) {
                            PHPFunctionsPart.this.fViewer.refresh();
                            PHPFunctionsPart.this.shouldRefresh = false;
                        }
                    }
                });
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.updateTitle();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.php_functions_view");
    }

    private void setUpPopupMenu() {
        this.showFunctionHelpAction = new ShowFunctionHelpAction();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ISelection selection = PHPFunctionsPart.this.fViewer.getSelection();
                if (!selection.isEmpty()) {
                    IStructuredSelection s = (IStructuredSelection)selection;
                    String url = PHPManualFactory.getManual().getURLForManual((PHPCodeData)s.getFirstElement());
                    if (url != null) {
                        PHPFunctionsPart.this.showFunctionHelpAction.setURL(url);
                        mgr.add((IAction)PHPFunctionsPart.this.showFunctionHelpAction);
                    }
                }
            }
        });
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void updateInputForCurrentEditor(final IEditorPart editorPart) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PHPFunctionsPart.this.actionGroup.handleUpdateInput(editorPart);
            }
        });
    }

    private TreeViewer createViewer(Composite composite) {
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filteredTree = new FilteredTree(composite, 2820, patternFilter);
        return filteredTree.getViewer();
    }

    private void addMouseTrackListener() {
        final Tree tree = this.fViewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object o;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && (o = item.getData()) instanceof PHPCodeData) {
                    tree.setToolTipText(PHPFunctionsPart.this.fLabelProvider.getTooltipText(o));
                }
            }
        });
    }

    private void addDoubleClickListener() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PHPStructuredEditor editor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)PHPFunctionsPart.this.getViewSite().getPage().getActiveEditor());
                StructuredSelection selection = (StructuredSelection)PHPFunctionsPart.this.fViewer.getSelection();
                if (editor != null && editor instanceof ITextEditor && selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof PHPCodeData) {
                    PHPCodeData codeData = (PHPCodeData)selection.getFirstElement();
                    ITextEditor textEditor = (ITextEditor)editor;
                    int caretPosition = ((ITextSelection)textEditor.getSelectionProvider().getSelection()).getOffset();
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                    try {
                        document.replace(caretPosition, 0, codeData.getName());
                    }
                    catch (BadLocationException e) {
                        Logger.logException(e);
                    }
                    textEditor.setFocus();
                    textEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(document, caretPosition + codeData.getName().length(), 0));
                }
            }
        });
    }

    public void setFocus() {
        if (this.fViewer != null && !this.fViewer.getTree().isDisposed()) {
            this.fViewer.getTree().setFocus();
        }
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
    }

    void projectStateChanged(Object root) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.fViewer.refresh(root, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public PHPFunctionsContentProvider createContentProvider() {
        return new PHPFunctionsContentProvider();
    }

    private PHPFunctionsLabelProvider createLabelProvider() {
        return new PHPFunctionsLabelProvider(1090519051, 3, this.fContentProvider);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        super.dispose();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part.equals((Object)this)) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    PHPFunctionsPart.this.setFocus();
                }
            });
        }
        part = EditorUtility.getPHPStructuredEditor(part);
        if (this.getViewer().getTree().getVisible() && part != null) {
            this.updateInputForCurrentEditor((IEditorPart)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part.equals((Object)this) && this.getViewer().getInput() == null) {
            this.updateInputForCurrentEditor(null);
            this.setFocus();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        PHPUiPlugin.createStandardGroups(menu);
    }

    void editorActivated(IEditorPart editor) {
    }

    public TreeViewer getViewer() {
        return this.fViewer;
    }

    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    String getFrameName(Object element) {
        if (element instanceof PHPCodeData) {
            return ((PHPCodeData)element).getName();
        }
        return this.fLabelProvider.getText(element);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof PHPWorkspaceModelManager ? PHPUIMessages.getString("PHPExplorerPart_workspace") : (element instanceof PHPCodeData ? PHPElementLabels.getTextLabel(element, 1090519051L) : this.fLabelProvider.getText(element))) : ((path = ((IResource)element).getFullPath()).isRoot() ? PHPUIMessages.getString("PHPExplorer_title") : path.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return result;
        }
        String wsstr = MessageFormat.format(PHPUIMessages.getString("PHPExplorer_toolTip"), this.fWorkingSetName);
        if (result.length() == 0) {
            return wsstr;
        }
        return MessageFormat.format(PHPUIMessages.getString("PHPExplorer_toolTip2"), result, this.fWorkingSetName);
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof PHPWorkspaceModelManager) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = PHPElementLabels.getTextLabel(input, 1090519051L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    class ShowFunctionHelpAction
    extends Action {
        private String url;

        public ShowFunctionHelpAction() {
            super(PHPUIMessages.getString("PHPFunctionsPart.0"));
        }

        public void setURL(String url) {
            this.url = url;
        }

        public void run() {
            if (this.url != null) {
                PHPManualFactory.getManual().showFunctionHelp(this.url);
            }
        }
    }
}

