/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.SuperClassLabelProvider;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.php.internal.ui.util.AppearanceAwareLabelProvider;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PHPOutlineLabelProvider
extends AppearanceAwareLabelProvider {
    AttributeShowingLabelProvider phpLabelProvider = new AttributeShowingLabelProvider();
    protected ILabelProvider superClassLabelProviderFragment = new SuperClassLabelProvider((ILabelProvider)this);
    private boolean showAttributes;

    public Image getImage(Object element) {
        if (element instanceof PHPCodeData) {
            Image image = this.superClassLabelProviderFragment.getImage(element);
            if (image != null) {
                return image;
            }
            return super.getImage(element);
        }
        if (element instanceof PHPOutlineContentProvider.GroupNode) {
            return ((PHPOutlineContentProvider.GroupNode)element).getImage();
        }
        if (element instanceof PHPTreeNode) {
            return ((PHPTreeNode)element).getImage();
        }
        return this.phpLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof PHPCodeData) {
            String text = this.superClassLabelProviderFragment.getText(element);
            if (text != null) {
                return text;
            }
            return super.getText(element);
        }
        if (element instanceof PHPOutlineContentProvider.GroupNode) {
            return ((PHPOutlineContentProvider.GroupNode)element).getText();
        }
        if (element instanceof PHPTreeNode) {
            return ((PHPTreeNode)element).getText();
        }
        return this.phpLabelProvider.getText(element);
    }

    public String getTooltipText(Object element) {
        return PHPElementLabels.getTooltipTextLabel(element);
    }

    public void setShowAttributes(boolean showAttributes) {
        this.showAttributes = showAttributes;
    }

    private class AttributeShowingLabelProvider
    extends JFaceNodeLabelProvider {
        private AttributeShowingLabelProvider() {
        }

        public String getText(Object o) {
            Node node;
            StringBuffer text = new StringBuffer(super.getText(o));
            if (o instanceof Node && (node = (Node)o).getNodeType() == 1 && PHPOutlineLabelProvider.this.showAttributes && node.hasAttributes()) {
                int i;
                Element element = (Element)node;
                NamedNodeMap attributes = element.getAttributes();
                Node idTypedAttribute = null;
                ArrayList<Node> requiredAttribute = new ArrayList<Node>(2);
                boolean hasId = false;
                boolean hasName = false;
                ArrayList<Node> shownAttribute = new ArrayList<Node>(2);
                CMElementDeclaration elementDecl = null;
                ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
                if (mq != null) {
                    elementDecl = mq.getCMElementDeclaration(element);
                }
                if (elementDecl != null) {
                    i = 0;
                    while (i < attributes.getLength() && idTypedAttribute == null) {
                        Node attr = attributes.item(i);
                        String attrName = attr.getNodeName();
                        CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)elementDecl.getAttributes().getNamedItem(attrName);
                        if (attrDecl != null) {
                            if (attrDecl.getAttrType() != null && "ID".equals(attrDecl.getAttrType().getDataTypeName())) {
                                idTypedAttribute = attr;
                            } else if (attrDecl.getUsage() == 2) {
                                requiredAttribute.add(attr);
                            } else if (node.getNodeName().equals("script") && attrName.equalsIgnoreCase("src")) {
                                requiredAttribute.add(attr);
                            } else {
                                hasId = hasId || attrName.equals("id");
                                hasName = hasName || attrName.equals("name");
                            }
                        }
                        ++i;
                    }
                }
                if (idTypedAttribute != null) {
                    shownAttribute.add(idTypedAttribute);
                } else if (requiredAttribute.size() > 0) {
                    shownAttribute.addAll(requiredAttribute);
                } else if (hasId) {
                    shownAttribute.add(attributes.getNamedItem("id"));
                } else if (hasName) {
                    shownAttribute.add(attributes.getNamedItem("name"));
                }
                if (shownAttribute == null) {
                    shownAttribute.add(attributes.item(0));
                }
                i = 0;
                while (i < shownAttribute.size()) {
                    Node curr = (Node)shownAttribute.get(i);
                    String attributeName = curr.getNodeName();
                    if (attributeName != null && attributeName.length() > 0) {
                        text.append(" " + attributeName);
                        String attributeValue = curr.getNodeValue();
                        if (attributeValue != null && attributeValue.length() > 0) {
                            text.append("=" + StringUtils.strip((String)attributeValue));
                        }
                    }
                    ++i;
                }
            }
            return text.toString();
        }
    }
}

