/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.dialogs.AdaptableForwarder;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class IncludePathInfoPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static String TYPE_TITLE = IDEWorkbenchMessages.ResourceInfo_type;
    private static String LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_location;
    private static String PATH_TITLE = PHPUIMessages.getString("IncludePathInfoPage.Identifier");
    private static final int MAX_VALUE_WIDTH = 80;

    private Composite createBasicInfoGroup(Composite parent, PHPIncludePathModel ipModel) {
        Font font = parent.getFont();
        Composite basicInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        basicInfoComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        basicInfoComposite.setLayoutData((Object)data);
        basicInfoComposite.setFont(font);
        Label pathLabel = new Label(basicInfoComposite, 0);
        pathLabel.setText(PATH_TITLE);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        pathLabel.setLayoutData((Object)gd);
        pathLabel.setFont(font);
        Text pathValueText = new Text(basicInfoComposite, 72);
        IPath modelLocation = PHPModelUtil.getIncludeModelLocation((IPhpModel)ipModel);
        String pathString = TextProcessor.process((String)modelLocation.toString());
        pathValueText.setText(ipModel.getID());
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        pathValueText.setLayoutData((Object)gd);
        pathValueText.setFont(font);
        pathValueText.setBackground(pathValueText.getDisplay().getSystemColor(22));
        Label typeTitle = new Label(basicInfoComposite, 16384);
        typeTitle.setText(TYPE_TITLE);
        typeTitle.setFont(font);
        Text typeValue = new Text(basicInfoComposite, 16392);
        typeValue.setText(ipModel.getType().toString());
        typeValue.setBackground(typeValue.getDisplay().getSystemColor(22));
        typeValue.setFont(font);
        Label locationTitle = new Label(basicInfoComposite, 16384);
        locationTitle.setText(LOCATION_TITLE);
        gd = new GridData();
        gd.verticalAlignment = 128;
        locationTitle.setLayoutData((Object)gd);
        locationTitle.setFont(font);
        Text locationValue = new Text(basicInfoComposite, 72);
        String locationStr = TextProcessor.process((String)pathString);
        locationValue.setText(locationStr);
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        locationValue.setLayoutData((Object)gd);
        locationValue.setFont(font);
        locationValue.setBackground(locationValue.getDisplay().getSystemColor(22));
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        return basicInfoComposite;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.resource_info_property_page_context");
        AdaptableForwarder adapter = (AdaptableForwarder)this.getElement();
        PHPIncludePathModel ipModel = (PHPIncludePathModel)adapter.getAdapter(PHPIncludePathModel.class);
        if (ipModel == null) {
            Label label = new Label(parent, 0);
            label.setText(IDEWorkbenchMessages.ResourceInfoPage_noResource);
            return label;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createBasicInfoGroup(composite, ipModel);
        this.createSeparator(composite);
        new Label(composite, 0);
        return composite;
    }

    private void createSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    public boolean performOk() {
        return true;
    }
}

