/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;

public class MembersOrderPreferenceCache
implements IPropertyChangeListener {
    public static final int INCLUDEFILES_INDEX = 0;
    public static final int CONSTANTS_INDEX = 1;
    public static final int STATIC_VARS_INDEX = 2;
    public static final int CONSTRUCTORS_INDEX = 3;
    public static final int STATIC_FUNCTIONS_INDEX = 4;
    public static final int FUNCTIONS_INDEX = 5;
    public static final int CLASS_INDEX = 6;
    public static final int VARS_INDEX = 7;
    public static final int N_CATEGORIES = 8;
    private static final int PUBLIC_INDEX = 0;
    private static final int DEFAULT_INDEX = 1;
    private static final int PROTECTED_INDEX = 2;
    private static final int PRIVATE_INDEX = 3;
    private static final int N_VISIBILITIES = 4;
    private int[] fCategoryOffsets = null;
    private boolean fSortByVisibility = PreferenceConstants.getPreferenceStore().getBoolean("enableVisibilityOrder");
    private int[] fVisibilityOffsets = null;

    public static boolean isMemberOrderProperty(String property) {
        return "outlinesortoption".equals(property) || "org.eclipse.php.ui.visibility.order".equals(property) || "enableVisibilityOrder".equals(property);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("outlinesortoption".equals(property)) {
            this.fCategoryOffsets = null;
        } else if ("org.eclipse.php.ui.visibility.order".equals(property)) {
            this.fVisibilityOffsets = null;
        } else if ("enableVisibilityOrder".equals(property)) {
            this.fSortByVisibility = PreferenceConstants.getPreferenceStore().getBoolean("enableVisibilityOrder");
        }
    }

    public int getCategoryIndex(int kind) {
        if (this.fCategoryOffsets == null) {
            this.fCategoryOffsets = this.getCategoryOffsets();
        }
        return this.fCategoryOffsets[kind];
    }

    private int[] getCategoryOffsets() {
        String key;
        int[] offsets = new int[8];
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean success = this.fillCategoryOffsetsFromPreferenceString(store.getString(key = "outlinesortoption"), offsets);
        if (!success) {
            store.setToDefault(key);
            this.fillCategoryOffsetsFromPreferenceString(store.getDefaultString(key), offsets);
        }
        return offsets;
    }

    private boolean fillCategoryOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if ("T".equals(token)) {
                offsets[6] = i++;
                continue;
            }
            if ("I".equals(token)) {
                offsets[0] = i++;
                continue;
            }
            if ("F".equals(token)) {
                offsets[5] = i++;
                continue;
            }
            if ("V".equals(token)) {
                offsets[7] = i++;
                continue;
            }
            if ("SV".equals(token)) {
                offsets[2] = i++;
                continue;
            }
            if ("SF".equals(token)) {
                offsets[4] = i++;
                continue;
            }
            if ("C".equals(token)) {
                offsets[3] = i++;
                continue;
            }
            if (!"S".equals(token)) continue;
            offsets[1] = i++;
        }
        return i == 8;
    }

    public boolean isSortByVisibility() {
        return this.fSortByVisibility;
    }

    public int getVisibilityIndex(int modifierFlags) {
        if (this.fVisibilityOffsets == null) {
            this.fVisibilityOffsets = this.getVisibilityOffsets();
        }
        int kind = 1;
        if (PHPModifier.isPublic((int)modifierFlags)) {
            kind = 0;
        } else if (PHPModifier.isProtected((int)modifierFlags)) {
            kind = 2;
        } else if (PHPModifier.isPrivate((int)modifierFlags)) {
            kind = 3;
        }
        return this.fVisibilityOffsets[kind];
    }

    private int[] getVisibilityOffsets() {
        String key;
        int[] offsets = new int[4];
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean success = this.fillVisibilityOffsetsFromPreferenceString(store.getString(key = "org.eclipse.php.ui.visibility.order"), offsets);
        if (!success) {
            store.setToDefault(key);
            this.fillVisibilityOffsetsFromPreferenceString(store.getDefaultString(key), offsets);
        }
        return offsets;
    }

    private boolean fillVisibilityOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if ("B".equals(token)) {
                offsets[0] = i++;
                continue;
            }
            if ("V".equals(token)) {
                offsets[3] = i++;
                continue;
            }
            if ("R".equals(token)) {
                offsets[2] = i++;
                continue;
            }
            if (!"D".equals(token)) continue;
            offsets[1] = i++;
        }
        return i == 4;
    }
}

