/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.VariablePathDialogField;
import org.eclipse.php.internal.ui.preferences.includepath.ZipFileSelectionDialog;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EditVariableEntryDialog
extends StatusDialog {
    private IPath fFileVariablePath;
    private IStatus fNameStatus;
    private Set fExistingEntries;
    private VariablePathDialogField fFileNameField;
    private CLabel fFullPathResolvedLabel;

    public EditVariableEntryDialog(Shell parent, IPath initialEntry, IPath[] existingEntries) {
        super(parent);
        this.setTitle(PHPUIMessages.getString("EditVariableEntryDialog_title"));
        this.fExistingEntries = new HashSet();
        if (existingEntries != null) {
            int i = 0;
            while (i < existingEntries.length) {
                IPath curr = existingEntries[i];
                if (!curr.equals((Object)initialEntry)) {
                    this.fExistingEntries.add(curr);
                }
                ++i;
            }
        }
        SourceAttachmentAdapter adapter = new SourceAttachmentAdapter();
        this.fFileNameField = new VariablePathDialogField(adapter);
        this.fFileNameField.setDialogFieldListener(adapter);
        this.fFileNameField.setLabelText(PHPUIMessages.getString("EditVariableEntryDialog_filename_varlabel"));
        this.fFileNameField.setButtonLabel(PHPUIMessages.getString("EditVariableEntryDialog_filename_external_varbutton"));
        this.fFileNameField.setVariableButtonLabel(PHPUIMessages.getString("EditVariableEntryDialog_filename_variable_button"));
        String initialString = initialEntry != null ? initialEntry.toString() : "";
        this.fFileNameField.setText(initialString);
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.fFileNameField.getText());
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        int widthHint = this.convertWidthInCharsToPixels(50);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        this.fFileNameField.doFillIntoGrid(composite, 4);
        LayoutUtil.setHorizontalSpan((Control)this.fFileNameField.getLabelControl(null), 3);
        LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        this.fFullPathResolvedLabel = new CLabel(composite, 16384);
        this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        this.fFullPathResolvedLabel.setLayoutData((Object)new GridData(256));
        DialogField.createEmptySpace(composite, 2);
        this.fFileNameField.postSetFocusOnDialogField(parent.getDisplay());
        EditVariableEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void attachmentChangeControlPressed(DialogField field) {
        IPath zipFilePath;
        if (field == this.fFileNameField && (zipFilePath = this.chooseExtZipFile()) != null) {
            this.fFileNameField.setText(zipFilePath.toString());
        }
    }

    private void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        }
        this.doStatusLineUpdate();
    }

    private IPath chooseExtZipFile() {
        IPath currPath = this.getPath();
        IPath resolvedPath = this.getResolvedPath(currPath);
        File initialSelection = resolvedPath != null ? resolvedPath.toFile() : null;
        String currVariable = currPath.segment(0);
        ZipFileSelectionDialog dialog = new ZipFileSelectionDialog(this.getShell(), false, true);
        dialog.setTitle(PHPUIMessages.getString("EditVariableEntryDialog_extvardialog_title"));
        dialog.setMessage(PHPUIMessages.getString("EditVariableEntryDialog_extvardialog_description"));
        dialog.setInput(this.fFileVariablePath.toFile());
        dialog.setInitialSelection(initialSelection);
        if (dialog.open() == 0) {
            File result = (File)dialog.getResult()[0];
            IPath returnPath = Path.fromOSString((String)result.getPath()).makeAbsolute();
            return this.modifyPath(returnPath, currVariable);
        }
        return null;
    }

    private IPath getResolvedPath(IPath path) {
        IPath varPath;
        String varName;
        if (path != null && (varName = path.segment(0)) != null && (varPath = PHPProjectOptions.getIncludePathVariable((String)varName)) != null) {
            return varPath.append(path.removeFirstSegments(1));
        }
        return null;
    }

    private IPath modifyPath(IPath path, String varName) {
        if (varName == null || path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return new Path(varName);
        }
        IPath varPath = PHPProjectOptions.getIncludePathVariable((String)varName);
        path = varPath != null ? (varPath.isPrefixOf(path) ? path.removeFirstSegments(varPath.segmentCount()) : new Path(path.lastSegment())) : new Path(path.lastSegment());
        return new Path(varName).append(path);
    }

    private IStatus updateFileNameStatus() {
        StatusInfo status = new StatusInfo();
        this.fFileVariablePath = null;
        String fileName = this.fFileNameField.getText();
        if (fileName.length() == 0) {
            status.setError(PHPUIMessages.getString("EditVariableEntryDialog_filename_empty"));
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(PHPUIMessages.getString("EditVariableEntryDialog_filename_error_notvalid"));
            return status;
        }
        IPath filePath = Path.fromOSString((String)fileName);
        if (filePath.getDevice() != null) {
            status.setError(PHPUIMessages.getString("EditVariableEntryDialog_filename_error_deviceinpath"));
            return status;
        }
        String varName = filePath.segment(0);
        if (varName == null) {
            status.setError(PHPUIMessages.getString("EditVariableEntryDialog_filename_error_notvalid"));
            return status;
        }
        this.fFileVariablePath = PHPProjectOptions.getIncludePathVariable((String)varName);
        if (this.fFileVariablePath == null) {
            status.setError(PHPUIMessages.getString("EditVariableEntryDialog_filename_error_varnotexists"));
            return status;
        }
        IPath resolvedPath = this.fFileVariablePath.append(filePath.removeFirstSegments(1));
        if (resolvedPath.isEmpty()) {
            status.setWarning(PHPUIMessages.getString("EditVariableEntryDialog_filename_warning_varempty"));
            return status;
        }
        File file = resolvedPath.toFile();
        if (!file.isFile()) {
            String message = MessageFormat.format(PHPUIMessages.getString("EditVariableEntryDialog_filename_error_filenotexists"), resolvedPath.toOSString());
            status.setInfo(message);
            return status;
        }
        return status;
    }

    private String getResolvedLabelString() {
        IPath resolvedPath = this.getResolvedPath(this.getPath());
        if (resolvedPath != null) {
            return resolvedPath.toOSString();
        }
        return "";
    }

    private boolean canBrowseFileName() {
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private void doStatusLineUpdate() {
        IPath path;
        IStatus status;
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        }
        if (!(status = this.fNameStatus).matches(4) && this.fExistingEntries.contains(path = this.getPath())) {
            String message = PHPUIMessages.getString("EditVariableEntryDialog_filename_error_alreadyexists");
            status = new StatusInfo(4, message);
        }
        this.updateStatus(status);
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            EditVariableEntryDialog.this.attachmentChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            EditVariableEntryDialog.this.attachmentDialogFieldChanged(field);
        }
    }
}

