/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElementSorter;
import org.eclipse.php.internal.ui.preferences.includepath.IPListLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathBasePage;
import org.eclipse.php.internal.ui.util.ListContentProvider;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPUILabelProvider;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.ITreeListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.php.internal.ui.wizards.fields.TreeListDialogField;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ProjectsWorkbookPage
extends IncludePathBasePage {
    private final int IDX_ADDPROJECT = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private ListDialogField fIncludePathList;
    private IProject fCurrPHPProject;
    private TreeListDialogField fProjectsList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public ProjectsWorkbookPage(ListDialogField includePathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fIncludePathList = includePathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[4];
        stringArray[0] = PHPUIMessages.getString("ProjectsWorkbookPage_projects_add_button");
        stringArray[2] = PHPUIMessages.getString("ProjectsWorkbookPage_projects_edit_button");
        stringArray[3] = PHPUIMessages.getString("ProjectsWorkbookPage_projects_remove_button");
        String[] buttonLabels = stringArray;
        ProjectsAdapter adapter = new ProjectsAdapter();
        this.fProjectsList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new IPListLabelProvider());
        this.fProjectsList.setDialogFieldListener(adapter);
        this.fProjectsList.setLabelText(PHPUIMessages.getString("ProjectsWorkbookPage_projects_label"));
        this.fProjectsList.enableButton(3, false);
        this.fProjectsList.enableButton(2, false);
        this.fProjectsList.setViewerSorter(new IPListElementSorter());
    }

    public void init(IProject project) {
        this.updateProjectsList(project);
    }

    private void updateProjectsList(IProject currProject) {
        List cpelements = this.fIncludePathList.getElements();
        ArrayList<IPListElement> checkedProjects = new ArrayList<IPListElement>(cpelements.size());
        int i = cpelements.size() - 1;
        while (i >= 0) {
            IPListElement cpelem = (IPListElement)cpelements.get(i);
            if (this.isEntryKind(cpelem.getEntryKind())) {
                checkedProjects.add(cpelem);
            }
            --i;
        }
        this.fProjectsList.setElements(checkedProjects);
        this.fCurrPHPProject = currProject;
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fProjectsList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        return composite;
    }

    private void updateIncludePathList() {
        List projelements = this.fProjectsList.getElements();
        boolean remove = false;
        List cpelements = this.fIncludePathList.getElements();
        int i = cpelements.size() - 1;
        while (i >= 0) {
            IPListElement cpe = (IPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind()) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            cpelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fIncludePathList.setElements(cpelements);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fProjectsList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public boolean isEntryKind(int kind) {
        return kind == 2;
    }

    private void projectPageCustomButtonPressed(DialogField field, int index) {
        Object[] entries = null;
        switch (index) {
            case 0: {
                entries = this.openProjectDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (entries != null) {
            int nElementsChosen = entries.length;
            List cplist = this.fProjectsList.getElements();
            ArrayList<IPListElement> elementsToAdd = new ArrayList<IPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                IPListElement curr = entries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fProjectsList.addElements(elementsToAdd);
            if (index == 0) {
                this.fProjectsList.refresh();
            }
            this.fProjectsList.postSetSelection((ISelection)new StructuredSelection(entries));
        }
    }

    private void removeEntry() {
        List selElements = this.fProjectsList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof IPListElementAttribute) {
                IPListElementAttribute attrib = (IPListElementAttribute)elem;
                String key = attrib.getKey();
                Object value = null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fProjectsList.refresh();
            this.fIncludePathList.dialogFieldChanged();
        } else {
            this.fProjectsList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int elements = 0;
        int attributes = 0;
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof IPListElementAttribute) {
                IPListElementAttribute attrib = (IPListElementAttribute)elem;
                if (attrib.getValue() == null) {
                    return false;
                }
                ++attributes;
            } else if (elem instanceof IPListElement) {
                ++elements;
            }
            ++i;
        }
        return attributes == selElements.size() || elements == selElements.size();
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof IPListElement) {
            return false;
        }
        return elem instanceof IPListElementAttribute;
    }

    private void editEntry() {
        List selElements = this.fProjectsList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fProjectsList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((IPListElement)elem);
        } else if (elem instanceof IPListElementAttribute) {
            this.editAttributeEntry((IPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(IPListElementAttribute elem) {
        elem.getKey();
    }

    private void editElementEntry(IPListElement elem) {
        IPListElement[] res = this.openProjectDialog(elem);
        if (res != null && res.length > 0) {
            IPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fProjectsList.replaceElement(elem, curr);
        }
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    private IPListElement[] openProjectDialog(IPListElement elem) {
        ArrayList selectable = new ArrayList();
        selectable.addAll(Arrays.asList(PHPWorkspaceModelManager.getInstance().listProjects()));
        selectable.remove(this.fCurrPHPProject);
        List elements = this.fProjectsList.getElements();
        int i = 0;
        while (i < elements.size()) {
            IPListElement curr = (IPListElement)elements.get(i);
            selectable.remove(curr.getResource());
            ++i;
        }
        Object[] selectArr = selectable.toArray();
        new PHPElementSorter().sort(null, selectArr);
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), Arrays.asList(selectArr), (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new PHPUILabelProvider(), PHPUIMessages.getString("ProjectsWorkbookPage_chooseProjects_message"));
        dialog.setTitle(PHPUIMessages.getString("ProjectsWorkbookPage_chooseProjects_title"));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            IPListElement[] cpElements = new IPListElement[result.length];
            int i2 = 0;
            while (i2 < result.length) {
                IProject curr = (IProject)result[i2];
                cpElements[i2] = new IPListElement(this.fCurrPHPProject, 2, 1, curr.getFullPath(), (IResource)curr);
                ++i2;
            }
            return cpElements;
        }
        return null;
    }

    protected void projectPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fProjectsList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void projectPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fProjectsList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void projectPageDialogFieldChanged(DialogField field) {
        if (this.fCurrPHPProject != null) {
            this.updateIncludePathList();
        }
    }

    private void projectPageSelectionChanged(DialogField field) {
        List selElements = this.fProjectsList.getSelectedElements();
        this.fProjectsList.enableButton(2, this.canEdit(selElements));
        this.fProjectsList.enableButton(3, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fProjectsList.enableButton(0, noAttributes);
    }

    private class ProjectsAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private ProjectsAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            ProjectsWorkbookPage.this.projectPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            ProjectsWorkbookPage.this.projectPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            ProjectsWorkbookPage.this.projectPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            ProjectsWorkbookPage.this.projectPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof IPListElement) {
                return ((IPListElement)element).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof IPListElementAttribute) {
                return ((IPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            ProjectsWorkbookPage.this.projectPageDialogFieldChanged(field);
        }
    }
}

