/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.search.Messages;
import org.eclipse.php.internal.ui.search.PHPSearchEngine;
import org.eclipse.php.internal.ui.search.PHPSearchResult;
import org.eclipse.php.internal.ui.search.PatternQuerySpecification;
import org.eclipse.php.internal.ui.search.QuerySpecification;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class PHPSearchQuery
implements ISearchQuery {
    private ISearchResult fResult;
    private QuerySpecification fPatternData;

    public PHPSearchQuery(QuerySpecification data) {
        this.fPatternData = data;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        PHPSearchResult textResult = (PHPSearchResult)this.getSearchResult();
        textResult.removeAll();
        PHPSearchEngine engine = new PHPSearchEngine();
        int totalTicks = -1;
        monitor.beginTask(PHPUIMessages.getString("PHPSearchQuery_task_label"), totalTicks);
        SubProgressMonitor mainSearchPM = new SubProgressMonitor(monitor, totalTicks);
        String stringPattern = null;
        PatternQuerySpecification patternSpec = (PatternQuerySpecification)this.fPatternData;
        stringPattern = patternSpec.getQuery();
        engine.search(stringPattern, this.fPatternData.getScope(), textResult, patternSpec.isCaseSensitive(), (IProgressMonitor)mainSearchPM);
        String message = Messages.format(PHPUIMessages.getString("PHPSearchQuery_status_ok_message"), String.valueOf(textResult.getMatchCount()));
        return new Status(0, PHPUiPlugin.getPluginId(), 0, message, null);
    }

    public String getLabel() {
        return PHPUIMessages.getString("PHPSearchQuery_label");
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new PHPSearchResult(this);
        }
        return this.fResult;
    }

    QuerySpecification getSpecification() {
        return this.fPatternData;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getResultLabel(int matchCount) {
        if (matchCount == 1) {
            Object[] args = new String[]{this.fPatternData.getQuery(), this.fPatternData.getScopeDescription()};
            return Messages.format(PHPUIMessages.getString("PHPSearchOperation_singularOccurrencesPostfix"), args);
        }
        Object[] args = new Object[]{this.fPatternData.getQuery(), new Integer(matchCount), this.fPatternData.getScopeDescription()};
        return Messages.format(PHPUIMessages.getString("PHPSearchOperation_pluralOccurrencesPostfix"), args);
    }
}

