/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.search.IPHPSearchScope;
import org.eclipse.php.internal.ui.search.PHPSearchEngine;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class PHPSearchScopeFactory {
    private static final IPHPSearchScope EMPTY_SCOPE = PHPSearchEngine.createPHPSearchScope(0, new Object[0]);
    private static final Set EMPTY_SET = new HashSet(0);
    private static PHPSearchScopeFactory instance;

    private PHPSearchScopeFactory() {
    }

    public static PHPSearchScopeFactory getInstance() {
        if (instance == null) {
            instance = new PHPSearchScopeFactory();
        }
        return instance;
    }

    public IPHPSearchScope createWorkspaceSearchScope(int searchFor) {
        return PHPSearchEngine.createWorkspaceScope(searchFor);
    }

    public IPHPSearchScope createWorkingSetSearchScope(int searchFor, IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return EMPTY_SCOPE;
        }
        HashSet phpElements = new HashSet(workingSets.length * 10);
        int i = 0;
        while (i < workingSets.length) {
            this.addPHPElements(phpElements, workingSets[i]);
            ++i;
        }
        return this.createPHPSearchScope(searchFor, phpElements);
    }

    public IPHPSearchScope createSelectedPHPProjectSearchScope(int searchFor, ISelection selection) {
        IEditorInput input = this.getActiveEditorInput();
        if (input != null) {
            return PHPSearchScopeFactory.getInstance().internalCreateProjectScope(searchFor, input);
        }
        return this.internalCreateProjectScope(searchFor, selection);
    }

    public IPHPSearchScope createSelectedPHPSearchScope(int searchFor, ISelection selection) {
        HashSet phpElements;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            phpElements = new HashSet(((IStructuredSelection)selection).size());
            while (iter.hasNext()) {
                IResource resource;
                Object selectedElement = iter.next();
                if (selectedElement instanceof IResource) {
                    this.addPHPElements(phpElements, (IResource)selectedElement);
                    continue;
                }
                if (!(selectedElement instanceof IAdaptable) || (resource = (IResource)((IAdaptable)selectedElement).getAdapter(IResource.class)) == null) continue;
                this.addPHPElements(phpElements, resource);
            }
        } else {
            phpElements = EMPTY_SET;
        }
        return this.createPHPSearchScope(searchFor, phpElements);
    }

    private IPHPSearchScope createPHPSearchScope(int searchFor, Set phpElements) {
        if (phpElements.isEmpty()) {
            return EMPTY_SCOPE;
        }
        Object[] elementArray = phpElements.toArray(new Object[phpElements.size()]);
        return PHPSearchEngine.createPHPSearchScope(searchFor, elementArray);
    }

    private void addPHPElements(Set phpElements, IWorkingSet workingSet) {
        if (workingSet == null) {
            return;
        }
        IAdaptable[] elements = workingSet.getElements();
        int i = 0;
        while (i < elements.length) {
            IResource resource = (IResource)elements[i].getAdapter(IResource.class);
            if (resource != null) {
                phpElements.add(resource);
            }
            ++i;
        }
    }

    private void addPHPElements(Set phpElements, IResource resource) {
        if (resource == null) {
            return;
        }
        phpElements.add(resource);
    }

    public IProject[] getPHPProjects(IPHPSearchScope scope) {
        IProject[] projects = scope.getAllEnclosingProjects();
        HashSet<IProject> temp = new HashSet<IProject>();
        int i = 0;
        while (i < projects.length) {
            block4: {
                block5: {
                    try {
                        if (!projects[i].isAccessible()) break block4;
                        if (!projects[i].hasNature("org.eclipse.php.core.PHPNature")) {
                        }
                        break block5;
                    }
                    catch (CoreException e) {
                        PHPUiPlugin.log(e);
                    }
                    break block4;
                }
                temp.add(projects[i]);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }

    public IWorkingSet[] queryWorkingSets() {
        IWorkingSet[] workingSets;
        Shell shell = PHPUiPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }

    private IPHPSearchScope internalCreateProjectScope(int searchFor, IEditorInput input) {
        IAdaptable inputElement = this.getEditorInputElement(input);
        StructuredSelection selection = inputElement != null ? new StructuredSelection((Object)inputElement) : StructuredSelection.EMPTY;
        return this.internalCreateProjectScope(searchFor, (ISelection)selection);
    }

    private IAdaptable getEditorInputElement(IEditorInput input) {
        return null;
    }

    private IEditorInput getActiveEditorInput() {
        IEditorPart editor;
        IWorkbenchPage page = PHPUiPlugin.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null && editor.equals(page.getActivePart())) {
            return editor.getEditorInput();
        }
        return null;
    }

    private IPHPSearchScope internalCreateProjectScope(int searchFor, ISelection selection) {
        Set phpProjects = this.getPHPProjects(selection);
        return this.createPHPSearchScope(searchFor, phpProjects);
    }

    private Set getPHPProjects(ISelection selection) {
        HashSet<IProject> phpProjects;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            phpProjects = new HashSet<IProject>(((IStructuredSelection)selection).size());
            while (iter.hasNext()) {
                Object selectedElement = iter.next();
                IResource resource = null;
                if (selectedElement instanceof IResource) {
                    resource = (IResource)selectedElement;
                } else if (selectedElement instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)selectedElement).getAdapter(IResource.class);
                }
                if (resource == null) continue;
                IProject project = resource.getProject();
                try {
                    if (!project.hasNature("org.eclipse.php.core.PHPNature")) continue;
                    phpProjects.add(project);
                }
                catch (CoreException e) {
                    PHPUiPlugin.log(e);
                }
            }
        } else {
            phpProjects = EMPTY_SET;
        }
        return phpProjects;
    }

    public IProject[] getProjects(IPHPSearchScope scope) {
        IProject[] projects = scope.getAllEnclosingProjects();
        HashSet<IProject> temp = new HashSet<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                temp.add(projects[i]);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }
}

