/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.search.PHPSearchContentProvider;
import org.eclipse.php.internal.ui.search.PHPSearchResult;
import org.eclipse.php.internal.ui.search.PHPSearchResultPage;
import org.eclipse.php.internal.ui.search.decorators.IPHPDataLeafMarker;

public class PHPSearchTreeContentProvider
extends PHPSearchContentProvider
implements ITreeContentProvider {
    public static final int LEVEL_PROJECT = 0;
    public static final int LEVEL_FILE = 1;
    public static final int LEVEL_TYPE = 2;
    protected final Object[] EMPTY_ARR = new Object[0];
    private Map fChildrenMap;
    protected PHPSearchResult fResult;
    private int groupingLevel;

    PHPSearchTreeContentProvider(PHPSearchResultPage page, int groupingLevel) {
        super(page);
        this.groupingLevel = groupingLevel;
    }

    public void setLevel(int level) {
        this.groupingLevel = level;
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    protected void initialize(PHPSearchResult result) {
        this.fResult = result;
        this.fChildrenMap = new HashMap();
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                if (this.getPage().getDisplayedMatchCount(elements[i]) > 0) {
                    this.insert(null, null, elements[i]);
                }
                ++i;
            }
        }
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getPage().getViewer();
        if (this.fResult == null) {
            return;
        }
        HashSet toRemove = new HashSet();
        HashSet toUpdate = new HashSet();
        HashMap toAdd = new HashMap();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.getPage().getDisplayedMatchCount(updatedElements[i]) > 0) {
                this.insert(toAdd, toUpdate, updatedElements[i]);
            } else {
                this.remove(toRemove, toUpdate, updatedElements[i]);
            }
            ++i;
        }
        viewer.remove(toRemove.toArray());
        for (Object parent : toAdd.keySet()) {
            HashSet children = (HashSet)toAdd.get(parent);
            viewer.add(parent, children.toArray());
        }
        Iterator elementsToUpdate = toUpdate.iterator();
        while (elementsToUpdate.hasNext()) {
            viewer.refresh(elementsToUpdate.next());
        }
    }

    protected void remove(Set toRemove, Set toUpdate, Object element) {
        if (this.hasChildren(element)) {
            if (toUpdate != null) {
                toUpdate.add(element);
            }
        } else if (this.getPage().getDisplayedMatchCount(element) == 0) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                if (this.removeFromSiblings(element, parent)) {
                    this.remove(toRemove, toUpdate, parent);
                }
            } else if (this.removeFromSiblings(element, (Object)this.fResult) && toRemove != null) {
                toRemove.add(element);
            }
        } else if (toUpdate != null) {
            toUpdate.add(element);
        }
    }

    private boolean removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            return siblings.remove(element);
        }
        return false;
    }

    protected void insert(Map toAdd, Set toUpdate, Object child) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (toAdd != null) {
                    this.insertInto(parent, child, toAdd);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this.fResult, child) && toAdd != null) {
            this.insertInto((Object)this.fResult, child, toAdd);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        return this.insertInto(parent, child, this.fChildrenMap);
    }

    private boolean insertInto(Object parent, Object child, Map map) {
        HashSet<Object> children = (HashSet<Object>)map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void clear() {
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof PHPCodeData) {
            PHPCodeData cd = (PHPCodeData)element;
            PHPCodeData res = cd.getContainer();
            if (res != null) {
                if (this.groupingLevel == 2 && res instanceof PHPFileData) {
                    return null;
                }
                return res;
            }
            if (this.groupingLevel == 0 && cd instanceof IPHPDataLeafMarker) {
                return ((IPHPDataLeafMarker)cd).getProject();
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

