/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.php.internal.ui.PHPElementLabelProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.search.Messages;
import org.eclipse.php.internal.ui.search.PHPSearchResultPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class SearchLabelProvider
extends PHPElementLabelProvider {
    public static final String PROPERTY_MATCH_COUNT = "org.eclipse.php.search.matchCount";
    private static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    private static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    private Color fPotentialMatchFgColor;
    private Map fLabelProviderMap;
    protected PHPSearchResultPage fPage;
    private ScopedPreferenceStore fSearchPreferences;
    private IPropertyChangeListener fSearchPropertyListener;

    public SearchLabelProvider(PHPSearchResultPage page, int flags) {
        super(flags);
        this.fPage = page;
        this.fLabelProviderMap = new HashMap(5);
        this.fSearchPreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.search");
        this.fSearchPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SearchLabelProvider.this.doSearchPropertyChange(event);
            }
        };
        this.fSearchPreferences.addPropertyChangeListener(this.fSearchPropertyListener);
    }

    final void doSearchPropertyChange(PropertyChangeEvent event) {
        if (this.fPotentialMatchFgColor == null) {
            return;
        }
        if (POTENTIAL_MATCH_FG_COLOR.equals(event.getProperty()) || EMPHASIZE_POTENTIAL_MATCHES.equals(event.getProperty())) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
            LabelProviderChangedEvent lpEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
            this.fireLabelProviderChanged(lpEvent);
        }
    }

    protected final int getNumberOfPotentialMatches(Object element) {
        int res = 0;
        return res;
    }

    protected final String getLabelWithCounts(Object element, String elementName) {
        int matchCount = this.fPage.getDisplayedMatchCount(element);
        int potentialCount = this.getNumberOfPotentialMatches(element);
        if (matchCount < 2) {
            if (matchCount == 1 && this.hasChildren(element)) {
                if (potentialCount > 0) {
                    return Messages.format(PHPUIMessages.getString("SearchLabelProvider_potential_singular"), elementName);
                }
                return Messages.format(PHPUIMessages.getString("SearchLabelProvider_exact_singular"), elementName);
            }
            if (potentialCount > 0) {
                return Messages.format(PHPUIMessages.getString("SearchLabelProvider_potential_noCount"), elementName);
            }
            return Messages.format(PHPUIMessages.getString("SearchLabelProvider_exact_noCount"), elementName);
        }
        int exactCount = matchCount - potentialCount;
        if (potentialCount > 0 && exactCount > 0) {
            Object[] args = new String[]{elementName, String.valueOf(matchCount), String.valueOf(exactCount), String.valueOf(potentialCount)};
            return Messages.format(PHPUIMessages.getString("SearchLabelProvider_exact_and_potential_plural"), args);
        }
        if (exactCount == 0) {
            Object[] args = new String[]{elementName, String.valueOf(matchCount)};
            return Messages.format(PHPUIMessages.getString("SearchLabelProvider_potential_plural"), args);
        }
        Object[] args = new String[]{elementName, String.valueOf(matchCount)};
        return Messages.format(PHPUIMessages.getString("SearchLabelProvider_exact_plural"), args);
    }

    protected boolean hasChildren(Object elem) {
        return false;
    }

    public void dispose() {
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
        }
        this.fSearchPreferences.removePropertyChangeListener(this.fSearchPropertyListener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.dispose();
        }
        this.fSearchPreferences = null;
        this.fSearchPropertyListener = null;
        this.fLabelProviderMap.clear();
        super.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.addListener(listener);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return PROPERTY_MATCH_COUNT.equals(property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.removeListener(listener);
        }
    }

    private boolean arePotentialMatchesEmphasized() {
        return this.fSearchPreferences.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }

    private RGB getPotentialMatchForegroundColor() {
        return PreferenceConverter.getColor((IPreferenceStore)this.fSearchPreferences, (String)POTENTIAL_MATCH_FG_COLOR);
    }
}

