/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;

public class TreeProvider {
    private static final String EXTENSION_POINT_NAME = "phpTreeContentProviders";
    private static final String TREE_CONTENT_PROVIDOR_TAG = "provider";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static TreeProvider[] fgTreeProviders;
    private IConfigurationElement fElement;
    private String[] targetIDs = new String[0];

    public TreeProvider(IConfigurationElement element) {
        this.fElement = element;
        String target = element.getAttribute(TARGET_ID_ATTRIBUTE);
        if (target != null && target.trim().length() > 0) {
            this.targetIDs = target.split(",");
        }
    }

    public static TreeProvider[] getTreeProviders() {
        if (fgTreeProviders == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
            fgTreeProviders = TreeProvider.createTreeProviders(elements);
        }
        return fgTreeProviders;
    }

    private static TreeProvider[] createTreeProviders(IConfigurationElement[] elements) {
        ArrayList<TreeProvider> result = new ArrayList<TreeProvider>(5);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (TREE_CONTENT_PROVIDOR_TAG.equals(element.getName())) {
                TreeProvider provider = new TreeProvider(element);
                result.add(provider);
            }
            ++i;
        }
        return result.toArray(new TreeProvider[result.size()]);
    }

    public static IPHPTreeContentProvider[] getTreeProviders(String targetId) {
        TreeProvider[] treeProviders = TreeProvider.getTreeProviders();
        ArrayList<IPHPTreeContentProvider> result = new ArrayList<IPHPTreeContentProvider>(treeProviders.length);
        int i = 0;
        while (i < treeProviders.length) {
            if (treeProviders[i].targets(targetId)) {
                result.add(treeProviders[i].createProvider());
            }
            ++i;
        }
        return result.toArray(new IPHPTreeContentProvider[result.size()]);
    }

    private IPHPTreeContentProvider createProvider() {
        final IPHPTreeContentProvider[] result = new IPHPTreeContentProvider[1];
        String message = PHPUIMessages.getString("TreeProvider.1");
        SafeRunnable code = new SafeRunnable(message){

            public void run() throws Exception {
                result[0] = (IPHPTreeContentProvider)TreeProvider.this.fElement.createExecutableExtension(TreeProvider.CLASS_ATTRIBUTE);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
        return result[0];
    }

    private boolean targets(String targetId) {
        if (this.targetIDs.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.targetIDs.length) {
            if (this.targetIDs[i].equals(targetId)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

