/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;

    public PHPElementImageProvider() {
        ISharedImages images = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = PHPPluginImages.DESC_OBJS_PHP_PROJECT;
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = PHPUiPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof PHPCodeData) {
            return this.getPHPImageDescriptor((PHPCodeData)element, flags);
        }
        if (element instanceof PHPProjectModel) {
            return DESC_OBJ_PROJECT;
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if ("as".equals(file.getFileExtension())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        if (element.equals("constants")) {
            return PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP;
        }
        if (element instanceof PHPIncludePathModel) {
            PHPIncludePathModel model = (PHPIncludePathModel)element;
            switch (model.getType()) {
                case VARIABLE: {
                    return PHPPluginImages.DESC_OBJS_ENV_VAR;
                }
            }
            return PHPPluginImages.DESC_OBJS_LIBRARY;
        }
        if (element instanceof PhpModelProxy) {
            return DESC_OBJ_PROJECT;
        }
        switch (ProjectOutlineContentProvider.getNodeType(element)) {
            case 3: {
                return PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP;
            }
            case 2: {
                return PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP;
            }
            case 4: {
                return PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP;
            }
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = PHPElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(PHPPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getPHPImageDescriptor(PHPCodeData element, int flags) {
        int adornmentFlags = this.computePHPAdornmentFlags(element, flags);
        Point size = PHPElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(this.getBaseImageDescriptor(element, flags), adornmentFlags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = PHPElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getBaseImageDescriptor(PHPCodeData element, int renderFlags) {
        if (element instanceof PHPFunctionData) {
            PHPFunctionData member = (PHPFunctionData)element;
            return PHPElementImageProvider.getMethodImageDescriptor(member.getModifiers());
        }
        if (element instanceof PHPClassVarData) {
            PHPClassVarData var = (PHPClassVarData)element;
            return PHPElementImageProvider.getFieldImageDescriptor(var.getModifiers());
        }
        if (element instanceof PHPConstantData || element instanceof PHPClassConstData || element.equals("constants")) {
            return PHPPluginImages.DESC_CONSTANT;
        }
        if (element instanceof PHPClassData) {
            PHPClassData type = (PHPClassData)element;
            if (PHPElementImageProvider.useLightIcons(renderFlags)) {
                if (PHPModifier.isInterface((int)type.getModifiers())) {
                    return PHPPluginImages.DESC_OBJS_INTERFACE;
                }
                return PHPPluginImages.DESC_OBJS_CLASSALT;
            }
            return PHPElementImageProvider.getTypeImageDescriptor(type.getModifiers());
        }
        if (element instanceof PHPFileData) {
            return PHPPluginImages.DESC_OBJS_CUNIT;
        }
        if (element instanceof PHPIncludeFileData) {
            return PHPPluginImages.DESC_OBJS_INCLUDE;
        }
        if (element instanceof PHPProjectModel) {
            PHPProjectModel model = (PHPProjectModel)element;
            IProject project = PHPWorkspaceModelManager.getInstance().getProjectForModel(model);
            if (project.isOpen()) {
                ImageDescriptor result;
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                    return result;
                }
                return DESC_OBJ_PROJECT;
            }
            return DESC_OBJ_PROJECT_CLOSED;
        }
        if (element instanceof IContainer) {
            return this.getPHPFolderIcon(element, renderFlags);
        }
        if (element instanceof PHPWorkspaceModelManager) {
            return PHPPluginImages.DESC_OBJS_PHP_MODEL;
        }
        Assert.isTrue((boolean)false, (String)("no image for this  Type: " + element));
        return null;
    }

    protected ImageDescriptor getPHPFolderIcon(Object element, int renderFlags) {
        IContainer folder = (IContainer)element;
        boolean containsPHPElements = false;
        try {
            containsPHPElements = folder.members().length > 0;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!containsPHPElements) {
            // empty if block
        }
        if (!containsPHPElements) {
            return PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT;
        }
        return PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT;
    }

    public void dispose() {
    }

    private int computePHPAdornmentFlags(PHPCodeData element, int renderFlags) {
        int flags = 0;
        if (PHPElementImageProvider.showOverlayIcons(renderFlags)) {
            int modifiers = -1;
            if (element instanceof PHPFunctionData) {
                PHPFunctionData functionData = (PHPFunctionData)element;
                modifiers = functionData.getModifiers();
            } else if (element instanceof PHPConstantData || element instanceof PHPClassConstData) {
                flags |= 2;
            } else if (element instanceof PHPClassData) {
                PHPClassData classData = (PHPClassData)element;
                modifiers = classData.getModifiers();
            } else if (element instanceof PHPClassVarData) {
                PHPClassVarData classVarData = (PHPClassVarData)element;
                modifiers = classVarData.getModifiers();
            }
            if (modifiers != -1) {
                flags = this.computeAdornments(modifiers, flags);
            }
        }
        return flags;
    }

    private int computeAdornments(int modifiers, int flags) {
        if (PHPModifier.isAbstract((int)modifiers)) {
            flags |= 4;
        }
        if (PHPModifier.isFinal((int)modifiers)) {
            flags |= 8;
        }
        if (PHPModifier.isStatic((int)modifiers)) {
            flags |= 1;
        }
        return flags;
    }

    public static ImageDescriptor getMethodImageDescriptor(int flags) {
        if (PHPModifier.isProtected((int)flags)) {
            return PHPPluginImages.DESC_MISC_PROTECTED;
        }
        if (PHPModifier.isPrivate((int)flags)) {
            return PHPPluginImages.DESC_MISC_PRIVATE;
        }
        return PHPPluginImages.DESC_MISC_PUBLIC;
    }

    public static ImageDescriptor getFieldImageDescriptor(int flags) {
        if (PHPModifier.isProtected((int)flags)) {
            return PHPPluginImages.DESC_FIELD_PROTECTED;
        }
        if (PHPModifier.isPrivate((int)flags)) {
            return PHPPluginImages.DESC_FIELD_PRIVATE;
        }
        return PHPPluginImages.DESC_FIELD_PUBLIC;
    }

    public static ImageDescriptor getTypeImageDescriptor(int flags) {
        return PHPElementImageProvider.getClassImageDescriptor(flags);
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return PHPUiPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new PHPElementImageDescriptor(baseImage, adornments, size));
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if (PHPModifier.isInterface((int)flags)) {
            return PHPPluginImages.DESC_OBJS_INTERFACE;
        }
        return PHPPluginImages.DESC_OBJS_CLASS;
    }
}

