/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.wizards.PHPIncludePathPage;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardBasePage;
import org.eclipse.php.internal.ui.wizards.PHPRichProjectWizardBasePage;
import org.eclipse.php.internal.ui.wizards.PHPWizardPagesRegistry;
import org.eclipse.php.internal.ui.wizards.WizardPageFactory;
import org.eclipse.php.internal.ui.wizards.operations.PHPCreationDataModelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.osgi.service.prefs.BackingStoreException;

public class PHPProjectCreationWizard
extends DataModelWizard
implements IExecutableExtension,
INewWizard {
    private static final String ID = "org.eclipse.php.ui.wizards.PHPProjectCreationWizard";
    protected PHPIncludePathPage includePathPage;
    protected PHPProjectWizardBasePage basePage;
    protected final ArrayList wizardPagesList = new ArrayList();
    private IProject createdProject = null;
    protected IConfigurationElement configElement;
    private List wizardPageFactories = new ArrayList();

    public PHPProjectCreationWizard(IDataModel model) {
        super(model);
        this.populateWizardFactoryList();
    }

    public PHPProjectCreationWizard() {
        this.populateWizardFactoryList();
    }

    protected IDataModelProvider getDefaultProvider() {
        return new PHPCreationDataModelProvider(this.wizardPageFactories);
    }

    public void doAddPages() {
        if (this.addDeafaultPages()) {
            this.addContributedPages();
        }
    }

    protected void addContributedPages() {
        for (WizardPageFactory pageFactory : this.wizardPageFactories) {
            IWizardPage currentPage = pageFactory.createPage(this.getDataModel());
            this.addPage(currentPage);
        }
    }

    protected boolean addDeafaultPages() {
        this.basePage = new PHPRichProjectWizardBasePage(this.getDataModel(), "page1");
        this.addPage((IWizardPage)this.basePage);
        this.includePathPage = new PHPIncludePathPage(this.getDataModel(), "page2");
        this.addPage((IWizardPage)this.includePathPage);
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(PHPUIMessages.getString("PHPProjectCreationWizard_PageTile"));
        this.setDefaultPageImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_PROJECT);
    }

    protected boolean prePerformFinish() {
        this.createdProject = (IProject)this.getDataModel().getProperty("IProjectCreationPropertiesNew.PROJECT");
        String location = (String)this.getDataModel().getProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION");
        File projectLocation = new File(location);
        if (projectLocation.exists() && projectLocation.isDirectory() && projectLocation.listFiles().length != 0) {
            LocationVerificationDialog dialog = new LocationVerificationDialog(this.getShell(), (String)this.getDataModel().getProperty("IProjectCreationPropertiesNew.PROJECT_NAME"), location);
            dialog.open();
            if (dialog.getCreateInNewLocation()) {
                this.getDataModel().setProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", (Object)(String.valueOf(location) + System.getProperty("file.separator") + this.createdProject.getName()));
            }
        }
        this.getDataModel().setProperty("org.eclipse.php.core.includePath", (Object)this.includePathPage.getIncludePathsBlock().getIncludepathEntries());
        this.basePage.setProjectOptionInModel(this.getDataModel());
        return super.prePerformFinish();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        if (this.createdProject != null) {
            try {
                new ProjectScope(this.createdProject).getNode("org.eclipse.php.core").flush();
            }
            catch (BackingStoreException e) {
                Logger.logException((Throwable)e);
            }
        }
        UIJob j = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)PHPProjectCreationWizard.this.configElement);
                return Status.OK_STATUS;
            }
        };
        j.setUser(false);
        j.schedule();
    }

    private void populateWizardFactoryList() {
        WizardPageFactory[] pageGenerators = PHPWizardPagesRegistry.getPageFactories(ID);
        if (pageGenerators != null) {
            WizardPageFactory[] wizardPageFactoryArray = pageGenerators;
            int n = pageGenerators.length;
            int n2 = 0;
            while (n2 < n) {
                WizardPageFactory element;
                WizardPageFactory pageFactory = element = wizardPageFactoryArray[n2];
                this.wizardPageFactories.add(pageFactory);
                ++n2;
            }
        }
    }

    static class LocationVerificationDialog
    extends MessageDialog {
        private String projectName;
        private String location;
        private boolean createInNewLocation = true;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    LocationVerificationDialog.this.createInNewLocation = button == LocationVerificationDialog.this.radio2;
                }
            }
        };

        LocationVerificationDialog(Shell parentShell, String project, String location) {
            super(parentShell, PHPUIMessages.getString("PHPProjectCreationWizard.title"), null, NLS.bind((String)PHPUIMessages.getString("PHPProjectCreationWizard.message"), (Object)location), 3, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.projectName = project;
            this.location = location;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.ide.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            this.radio1.setText(String.valueOf(PHPUIMessages.getString("PHPProjectCreationWizard.createProjectIn")) + this.location + ".");
            this.radio1.setFont(parent.getFont());
            Label detailsLabel = new Label(composite, 16384);
            detailsLabel.setText(String.valueOf(PHPUIMessages.getString("PHPProjectCreationWizard.details")) + this.location + PHPUIMessages.getString("PHPProjectCreationWizard.folder"));
            detailsLabel.setFont(parent.getFont());
            GC gc = new GC((Drawable)detailsLabel);
            gc.setFont(detailsLabel.getParent().getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            GridData data = new GridData();
            data.horizontalIndent = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)21);
            detailsLabel.setLayoutData((Object)data);
            detailsLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    LocationVerificationDialog.this.createInNewLocation = false;
                    LocationVerificationDialog.this.radio1.setSelection(!LocationVerificationDialog.this.createInNewLocation);
                    LocationVerificationDialog.this.radio2.setSelection(LocationVerificationDialog.this.createInNewLocation);
                }
            });
            new Label(composite, 16384);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            this.radio2.setText(String.valueOf(PHPUIMessages.getString("PHPProjectCreationWizard.createProjectIn")) + this.location + System.getProperty("file.separator") + this.projectName + ".");
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(!this.createInNewLocation);
            this.radio2.setSelection(this.createInNewLocation);
            return composite;
        }

        boolean getCreateInNewLocation() {
            return this.createInNewLocation;
        }

        protected Control createButtonBar(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(0).equalWidth(true).applyTo(composite);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(2, 1).applyTo((Control)composite);
            composite.setFont(parent.getFont());
            this.createButtonsForButtonBar(composite);
            return composite;
        }
    }
}

