/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.workingset.WorkingSetConfigurationDialog;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;

public class ConfigureWorkingSetAction
extends Action {
    private final IWorkbenchPartSite fSite;
    private WorkingSetModel fWorkingSetModel;

    public ConfigureWorkingSetAction(IWorkbenchPartSite site) {
        super(PHPUIMessages.getString("ConfigureWorkingSetAction_label"));
        this.fSite = site;
    }

    public void setWorkingSetModel(WorkingSetModel model) {
        this.fWorkingSetModel = model;
    }

    public void run() {
        ArrayList workingSets = new ArrayList(Arrays.asList(this.fWorkingSetModel.getAllWorkingSets()));
        WorkingSetConfigurationDialog dialog = new WorkingSetConfigurationDialog(this.fSite.getShell(), workingSets.toArray(new IWorkingSet[workingSets.size()]));
        dialog.setSelection(this.fWorkingSetModel.getActiveWorkingSets());
        if (dialog.open() == 0) {
            IWorkingSet[] selection = dialog.getSelection();
            this.fWorkingSetModel.setActiveWorkingSets(selection);
        }
    }
}

