/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.workingset.IWorkingSetActionGroup;
import org.eclipse.php.internal.ui.workingset.ViewAction;
import org.eclipse.php.internal.ui.workingset.ViewActionGroup;
import org.eclipse.php.internal.ui.workingset.WorkingSetFilterActionGroup;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.php.internal.ui.workingset.WorkingSetShowActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;

public class ExplorerViewActionGroup
extends ViewActionGroup {
    public static final int SHOW_PROJECTS = 1;
    public static final int SHOW_WORKING_SETS = 2;
    public static final String MODE_CHANGED = String.valueOf(ViewActionGroup.class.getName()) + ".mode_changed";
    private static final Integer INT_SHOW_PROJECTS = new Integer(1);
    private static final Integer INT_SHOW_WORKING_SETS = new Integer(2);
    private IPropertyChangeListener fChangeListener;
    private int fMode;
    private IMenuManager fMenuManager;
    private IWorkingSetActionGroup fActiveActionGroup;
    private WorkingSetShowActionGroup fShowActionGroup;
    private WorkingSetFilterActionGroup fFilterActionGroup;

    public ExplorerViewActionGroup(int mode, IPropertyChangeListener changeListener, IWorkbenchPartSite site) {
        this.fChangeListener = changeListener;
        this.fFilterActionGroup = new WorkingSetFilterActionGroup(site, changeListener);
        this.fShowActionGroup = new WorkingSetShowActionGroup(site);
        this.fMode = mode;
        this.fActiveActionGroup = this.showWorkingSets() ? this.fShowActionGroup : this.fFilterActionGroup;
    }

    public void dispose() {
        this.fFilterActionGroup.dispose();
        this.fShowActionGroup.dispose();
        this.fChangeListener = null;
        super.dispose();
    }

    public void setWorkingSetModel(WorkingSetModel model) {
        this.fShowActionGroup.setWorkingSetMode(model);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fMenuManager = actionBars.getMenuManager();
        MenuManager showMenu = new MenuManager(PHPUIMessages.getString("ViewActionGroup_show_label"));
        this.fillShowMenu((IMenuManager)showMenu);
        this.fMenuManager.add((IContributionItem)showMenu);
        this.fMenuManager.add((IContributionItem)new Separator("working_set_action_group"));
        if (this.fActiveActionGroup == null) {
            this.fActiveActionGroup = this.fFilterActionGroup;
        }
        ((ActionGroup)this.fActiveActionGroup).fillActionBars(actionBars);
    }

    private void fillShowMenu(IMenuManager menu) {
        ViewAction projects = new ViewAction(this, 1);
        projects.setText(PHPUIMessages.getString("ViewActionGroup_projects_label"));
        menu.add((IAction)projects);
        ViewAction workingSets = new ViewAction(this, 2);
        workingSets.setText(PHPUIMessages.getString("ViewActionGroup_workingSets_label"));
        menu.add((IAction)workingSets);
        if (this.fMode == 1) {
            projects.setChecked(true);
        } else {
            workingSets.setChecked(true);
        }
    }

    public void fillFilters(StructuredViewer viewer) {
        ViewerFilter workingSetFilter = this.fFilterActionGroup.getWorkingSetFilter();
        if (this.showProjects()) {
            viewer.addFilter(workingSetFilter);
        } else if (this.showWorkingSets()) {
            viewer.removeFilter(workingSetFilter);
        }
    }

    public void setMode(int mode) {
        PropertyChangeEvent event;
        this.fMode = mode;
        this.fActiveActionGroup.cleanViewMenu(this.fMenuManager);
        if (mode == 1) {
            this.fActiveActionGroup = this.fFilterActionGroup;
            event = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_WORKING_SETS, (Object)INT_SHOW_PROJECTS);
        } else {
            this.fActiveActionGroup = this.fShowActionGroup;
            event = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_PROJECTS, (Object)INT_SHOW_WORKING_SETS);
        }
        this.fActiveActionGroup.fillViewMenu(this.fMenuManager);
        this.fMenuManager.updateAll(true);
        this.fChangeListener.propertyChange(event);
    }

    public WorkingSetFilterActionGroup getFilterGroup() {
        return this.fFilterActionGroup;
    }

    public void restoreState(IMemento memento) {
        this.fFilterActionGroup.restoreState(memento);
    }

    public void saveState(IMemento memento) {
        this.fFilterActionGroup.saveState(memento);
    }

    private boolean showProjects() {
        return this.fMode == 1;
    }

    private boolean showWorkingSets() {
        return this.fMode == 2;
    }
}

