/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.functions.PHPFunctionsPart;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.workingset.ViewAction;
import org.eclipse.php.internal.ui.workingset.ViewActionGroup;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class FunctionsViewGroup
extends ViewActionGroup {
    public static final int PHP4 = 1;
    public static final int PHP5 = 2;
    public static final IPhpModel php4Model = PHPLanguageManagerProvider.instance().getPHPLanguageManager("php4").getModel();
    public static final IPhpModel php5Model = PHPLanguageManagerProvider.instance().getPHPLanguageManager("php5").getModel();
    private PHPFunctionsPart fPart;
    private ViewAction showPHP4FunctionsAction;
    private ViewAction showPHP5FunctionsAction;
    private int currentMode;

    public FunctionsViewGroup(PHPFunctionsPart part) {
        this.fPart = part;
        this.fillContextMenu(this.fPart.getViewSite().getActionBars().getMenuManager());
    }

    public void dispose() {
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.showPHP4FunctionsAction = new ViewAction(this, 1);
        this.showPHP4FunctionsAction.setText("PHP 4");
        this.showPHP5FunctionsAction = new ViewAction(this, 2);
        this.showPHP5FunctionsAction.setText("PHP 5");
        menu.add((IAction)this.showPHP4FunctionsAction);
        menu.add((IAction)this.showPHP5FunctionsAction);
    }

    public void setMode(int mode) {
        if (mode == this.currentMode) {
            return;
        }
        this.fPart.getViewer().setInput((Object)(mode == 1 ? php4Model : php5Model));
        this.currentMode = mode;
        this.updateActions();
    }

    private void updateActions() {
        if (this.currentMode == 1) {
            this.showPHP4FunctionsAction.setChecked(true);
            this.showPHP5FunctionsAction.setChecked(false);
        } else {
            this.showPHP5FunctionsAction.setChecked(true);
            this.showPHP4FunctionsAction.setChecked(false);
        }
    }

    public void handleUpdateInput(IEditorPart editorPart) {
        if (editorPart == null) {
            this.setMode(this.getVersion(PhpVersionProjectPropertyHandler.getVersion()));
            return;
        }
        PHPStructuredEditor phpEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)editorPart);
        if (phpEditor != null) {
            IFile file = phpEditor.getFile();
            if (file == null) {
                return;
            }
            String version = PhpVersionProjectPropertyHandler.getVersion((IProject)file.getProject());
            this.setMode(this.getVersion(version));
        }
    }

    private int getVersion(String s) {
        if ("php4".equals(s)) {
            return 1;
        }
        return 2;
    }
}

