/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.workingset.EditorTracker;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class HistoryWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.php.ui.HistoryWorkingSet";
    private IWorkingSet fWorkingSet;
    private Set fOpenFiles = new HashSet();
    private Tracker fTracker;
    private ModelListener fPHPListener;
    private int fMaxElements = 15;
    private IResourceChangeListener fResourceChangeListener;

    public HistoryWorkingSetUpdater() {
        this.initListeners();
    }

    public void add(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == null ? 1 : 0) != 0);
        this.fWorkingSet = workingSet;
    }

    public boolean remove(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == workingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.fWorkingSet == workingSet;
    }

    public void dispose() {
        if (this.fTracker != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.removeWindowListener((IWindowListener)this.fTracker);
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                windows[i].removePageListener((IPageListener)this.fTracker);
                IWorkbenchPage[] pages = windows[i].getPages();
                int j = 0;
                while (j < pages.length) {
                    pages[j].removePartListener((IPartListener)this.fTracker);
                    ++j;
                }
                ++i;
            }
            this.fTracker = null;
        }
        if (this.fPHPListener != null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener(this.fPHPListener);
            this.fPHPListener = null;
        }
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
    }

    private void initListeners() {
        this.fTracker = new Tracker();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this.fTracker);
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].addPageListener((IPageListener)this.fTracker);
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                pages[j].addPartListener((IPartListener)this.fTracker);
                ++j;
            }
            ++i;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fPHPListener = new ModelListener(){

            public void fileDataChanged(PHPFileData fileData) {
                IFile file = (IFile)PHPModelUtil.getResource((Object)fileData);
                HistoryWorkingSetUpdater.this.elementSaved((IAdaptable)file);
            }

            public void fileDataAdded(PHPFileData fileData) {
            }

            public void fileDataRemoved(PHPFileData fileData) {
                IFile file = (IFile)PHPModelUtil.getResource((Object)fileData);
                HistoryWorkingSetUpdater.this.elementRemoved((IAdaptable)file);
            }

            public void dataCleared() {
            }
        };
        PHPWorkspaceModelManager.getInstance().addModelListener(this.fPHPListener);
    }

    private void elementSaved(IAdaptable element) {
        if (!this.fOpenFiles.contains(element)) {
            return;
        }
        this.updateHistory(element);
    }

    private void elementRemoved(IAdaptable element) {
        this.fOpenFiles.remove(element);
        List elements = this.getElements();
        if (elements.remove(element)) {
            this.setElements(elements);
        }
    }

    private void elementMoved(IAdaptable oldElement, IAdaptable newElement) {
        List elements = this.getElements();
        int index = elements.indexOf(oldElement);
        if (index == -1) {
            return;
        }
        elements.set(index, newElement);
        this.fOpenFiles.remove(oldElement);
        this.fOpenFiles.add(newElement);
        this.setElements(elements);
    }

    private void projectClosed(IProject project) {
        List elements = this.getElements();
        int removed = 0;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IAdaptable element = (IAdaptable)iter.next();
            IProject container = this.getProject(element);
            if (!project.equals((Object)container)) continue;
            iter.remove();
            ++removed;
        }
        if (removed > 0) {
            this.setElements(elements);
        }
    }

    private IProject getProject(IAdaptable element) {
        if (element instanceof IResource) {
            return ((IResource)element).getProject();
        }
        if (element instanceof PHPCodeData) {
            return PHPModelUtil.getResource((Object)((PHPCodeData)element)).getProject();
        }
        return null;
    }

    private void updateHistory(IAdaptable element) {
        List elements = this.getElements();
        int index = elements.indexOf(element);
        if (index != -1) {
            elements.remove(index);
            elements.add(0, element);
        } else {
            if (elements.size() == this.fMaxElements) {
                elements.remove(elements.size() - 1);
            }
            elements.add(0, element);
        }
        this.setElements(elements);
    }

    private List getElements() {
        return new ArrayList(Arrays.asList(this.fWorkingSet.getElements()));
    }

    private void setElements(List elements) {
        this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() != 1) {
                            return true;
                        }
                        IFile file = (IFile)resource;
                        if ((delta.getKind() & 4) != 0) {
                            if ((delta.getFlags() & 0x100) != 0) {
                                HistoryWorkingSetUpdater.this.elementSaved((IAdaptable)file);
                            }
                        } else if ((delta.getKind() & 2) != 0) {
                            if ((delta.getFlags() & 0x2000) != 0) {
                                IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                                if (!newFile.exists()) {
                                    HistoryWorkingSetUpdater.this.elementRemoved((IAdaptable)file);
                                } else {
                                    HistoryWorkingSetUpdater.this.elementMoved((IAdaptable)file, (IAdaptable)newFile);
                                }
                            } else {
                                HistoryWorkingSetUpdater.this.elementRemoved((IAdaptable)file);
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException coreException) {}
        }
    }

    private class Tracker
    extends EditorTracker {
        private Tracker() {
        }

        public void editorOpened(IEditorPart part) {
            IAdaptable file = this.getInput(part);
            if (file == null) {
                return;
            }
            HistoryWorkingSetUpdater.this.fOpenFiles.add(file);
        }

        public void editorClosed(IEditorPart part) {
            IAdaptable file = this.getInput(part);
            if (file == null) {
                return;
            }
            HistoryWorkingSetUpdater.this.fOpenFiles.remove(file);
        }

        private IAdaptable getInput(IEditorPart part) {
            IEditorInput input = part.getEditorInput();
            if (!(input instanceof IFileEditorInput)) {
                return null;
            }
            return ((IFileEditorInput)input).getFile();
        }
    }
}

