/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class OthersWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.php.ui.OthersWorkingSet";
    private IWorkingSet fWorkingSet;
    private WorkingSetModel fWorkingSetModel;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fWorkingSetListener;

    public void add(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == null ? 1 : 0) != 0);
        this.fWorkingSet = workingSet;
    }

    public boolean remove(IWorkingSet workingSet) {
        Assert.isTrue((this.fWorkingSet == workingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.fWorkingSet == workingSet;
    }

    public void init(WorkingSetModel model) {
        this.fWorkingSetModel = model;
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fWorkingSetListener = new WorkingSetListener();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetListener);
        this.updateElements(this.fWorkingSetModel.getActiveWorkingSets());
    }

    public void dispose() {
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
    }

    public void updateElements() {
        this.updateElements(this.fWorkingSetModel.getActiveWorkingSets());
    }

    private void updateElements(IWorkingSet[] activeWorkingSets) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        HashSet<IResource> projects = new HashSet<IResource>();
        int i = 0;
        while (i < activeWorkingSets.length) {
            if (activeWorkingSets[i] != this.fWorkingSet) {
                IAdaptable[] elements = activeWorkingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IAdaptable element = elements[j];
                    IResource resource = (IResource)element.getAdapter(IResource.class);
                    if (resource != null && resource.getType() == 4) {
                        projects.add(resource);
                    }
                    ++j;
                }
            }
            ++i;
        }
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i2 = 0;
        while (i2 < allProjects.length) {
            block9: {
                block8: {
                    try {
                        if (allProjects[i2].hasNature("org.eclipse.php.core.PHPNature")) break block8;
                        break block9;
                    }
                    catch (CoreException coreException) {}
                }
                if (!projects.contains(allProjects[i2])) {
                    result.add(allProjects[i2]);
                }
            }
            ++i2;
        }
        this.fWorkingSet.setElements(result.toArray(new IAdaptable[result.size()]));
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(3, 4);
            if (affectedChildren.length > 0) {
                OthersWorkingSetUpdater.this.updateElements(OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets());
            } else {
                affectedChildren = delta.getAffectedChildren(4, 4);
                int i = 0;
                while (i < affectedChildren.length) {
                    IResourceDelta projectDelta = affectedChildren[i];
                    if ((projectDelta.getFlags() & 0x80000) != 0) {
                        OthersWorkingSetUpdater.this.updateElements(OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets());
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private class WorkingSetListener
    implements IPropertyChangeListener {
        private WorkingSetListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet[] activeWorkingSets;
            IWorkingSet changedWorkingSet;
            if ("workingSetContentChange".equals(event.getProperty()) && (changedWorkingSet = (IWorkingSet)event.getNewValue()) != OthersWorkingSetUpdater.this.fWorkingSet && this.contains(activeWorkingSets = OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets(), changedWorkingSet) && !"org.eclipse.php.ui.HistoryWorkingSet".equals(changedWorkingSet.getId())) {
                OthersWorkingSetUpdater.this.updateElements(activeWorkingSets);
            }
        }

        private boolean contains(IWorkingSet[] workingSets, IWorkingSet workingSet) {
            int i = 0;
            while (i < workingSets.length) {
                if (workingSets[i] == workingSet) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

