/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.util.AppearanceAwareLabelProvider;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.workingset.PHPWorkingSetPageContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class PHPWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = PHPUIMessages.getString("PHPWorkingSetPage_title");
    private static final String PAGE_ID = "phpWorkingSetPage";
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;

    public PHPWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, PHPPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.setDescription(PHPUIMessages.getString("PHPWorkingSetPage_workingSet_description"));
        this.fFirstCheck = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(PHPUIMessages.getString("PHPWorkingSetPage_workingSet_name"));
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PHPWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(PHPUIMessages.getString("PHPWorkingSetPage_workingSet_content"));
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fTree = new CheckboxTreeViewer(composite, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTreeContentProvider = new PHPWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider fPHPElementLabelProvider = new AppearanceAwareLabelProvider(1627389963, 3);
        this.fTree.setLabelProvider((IBaseLabelProvider)fPHPElementLabelProvider);
        this.fTree.setSorter((ViewerSorter)new PHPElementSorter());
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)PHPWorkspaceModelManager.getInstance());
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PHPWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                final Object element = event.getElement();
                if (!PHPWorkingSetPage.this.fTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)PHPWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PHPWorkingSetPage.this.setSubtreeChecked(element, PHPWorkingSetPage.this.fTree.getChecked(element), false);
                        }
                    });
                }
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(PHPUIMessages.getString("PHPWorkingSetPage_selectAll_label"));
        selectAllButton.setToolTipText(PHPUIMessages.getString("PHPWorkingSetPage_selectAll_toolTip"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPWorkingSetPage.this.fTree.setCheckedElements(PHPWorkingSetPage.this.fTreeContentProvider.getElements(PHPWorkingSetPage.this.fTree.getInput()));
                PHPWorkingSetPage.this.validateInput();
            }
        });
        selectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(PHPUIMessages.getString("PHPWorkingSetPage_deselectAll_label"));
        deselectAllButton.setToolTipText(PHPUIMessages.getString("PHPWorkingSetPage_deselectAll_toolTip"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPWorkingSetPage.this.fTree.setCheckedElements(new Object[0]);
                PHPWorkingSetPage.this.validateInput();
            }
        });
        deselectAllButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(deselectAllButton);
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.working_set_selection_dialog_context");
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(10);
        this.findCheckedElements(elements, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        } else {
            IAdaptable[] oldItems = this.fWorkingSet.getElements();
            ArrayList<IProject> closedWithChildren = new ArrayList<IProject>(elements.size());
            int i = 0;
            while (i < oldItems.length) {
                IProject project;
                IResource oldResource = null;
                oldResource = oldItems[i] instanceof IResource ? (IResource)oldItems[i] : (IResource)oldItems[i].getAdapter(IResource.class);
                if (oldResource != null && !oldResource.isAccessible() && (elements.contains(project = oldResource.getProject()) || closedWithChildren.contains(project))) {
                    elements.add(oldItems[i]);
                    elements.remove(project);
                    closedWithChildren.add(project);
                }
                ++i;
            }
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private void validateInput() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = PHPUIMessages.getString("PHPWorkingSetPage_warning_nameWhitespace");
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = PHPUIMessages.getString("PHPWorkingSetPage_warning_nameMustNotBeEmpty");
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = PHPUIMessages.getString("PHPWorkingSetPage_warning_workingSetExists");
                }
                ++i;
            }
        }
        if (errorMessage == null && !this.hasCheckedElement()) {
            errorMessage = PHPUIMessages.getString("PHPWorkingSetPage_warning_resourceMustBeChecked");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasCheckedElement() {
        TreeItem[] items = this.fTree.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.fTree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
            } else if (this.fTree.getChecked(children[i])) {
                checkedResources.add(children[i]);
            }
            ++i;
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                boolean state = event.getChecked();
                PHPWorkingSetPage.this.fTree.setGrayed((Object)element, false);
                if (PHPWorkingSetPage.this.isExpandable(element)) {
                    PHPWorkingSetPage.this.setSubtreeChecked(element, state, state);
                }
                PHPWorkingSetPage.this.updateParentState(element, state);
                PHPWorkingSetPage.this.validateInput();
            }
        });
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        if (!(parent instanceof IAdaptable)) {
            return;
        }
        IContainer container = (IContainer)((IAdaptable)parent).getAdapter(IContainer.class);
        if (!this.fTree.getExpandedState(parent) && checkExpandedState || container != null && !container.isAccessible()) {
            return;
        }
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.fTree.setChecked(element, true);
                this.fTree.setGrayed(element, false);
            } else {
                this.fTree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(Object child, boolean baseChildState) {
        IResource resource;
        if (child == null) {
            return;
        }
        if (child instanceof IAdaptable && (resource = (IResource)((IAdaptable)child).getAdapter(IResource.class)) != null && !resource.isAccessible()) {
            return;
        }
        Object parent = this.fTreeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.fTree.getChecked(children[i]) != baseChildState || this.fTree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.fTree.setGrayed(parent, !allSameState);
        this.fTree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object element;
                Object[] elements;
                if (PHPWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage page = PHPUiPlugin.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IWorkbenchPart part = PHPUiPlugin.getActivePage().getActivePart();
                    if (part == null) {
                        return;
                    }
                    elements = SelectionConverter.getStructuredSelection(part).toArray();
                    int i = 0;
                    while (i < elements.length) {
                        PHPFileData phpFile;
                        if (elements[i] instanceof IFile && (phpFile = PHPWorkspaceModelManager.getInstance().getModelForFile((IFile)elements[i], false)) != null) {
                            elements[i] = phpFile;
                        }
                        ++i;
                    }
                } else {
                    elements = PHPWorkingSetPage.this.fWorkingSet.getElements();
                }
                int i = 0;
                while (i < elements.length) {
                    IResource resource;
                    IProject project;
                    element = elements[i];
                    if (element instanceof IResource && !(project = ((IResource)element).getProject()).isAccessible()) {
                        elements[i] = project;
                    }
                    if (element instanceof PHPCodeData && (resource = PHPModelUtil.getResource((Object)element)) != null && !resource.getProject().isAccessible()) {
                        elements[i] = resource.getProject();
                    }
                    ++i;
                }
                PHPWorkingSetPage.this.fTree.setCheckedElements(elements);
                i = 0;
                while (i < elements.length) {
                    element = elements[i];
                    if (PHPWorkingSetPage.this.isExpandable(element)) {
                        PHPWorkingSetPage.this.setSubtreeChecked(element, true, true);
                    }
                    PHPWorkingSetPage.this.updateParentState(element, true);
                    ++i;
                }
            }
        });
    }

    private boolean isExpandable(Object element) {
        return element instanceof PHPWorkspaceModelManager || element instanceof IContainer;
    }
}

