/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;

public class PhpElementConciliator {
    private static final String THIS = "this";
    public static final int CONCILIATOR_UNKNOWN = 0;
    public static final int CONCILIATOR_GLOBAL_VARIABLE = 1;
    public static final int CONCILIATOR_FUNCTION = 2;
    public static final int CONCILIATOR_LOCAL_VARIABLE = 3;
    public static final int CONCILIATOR_CLASSNAME = 4;
    public static final int CONCILIATOR_CONSTANT = 5;
    public static final int CONCILIATOR_CLASS_MEMBER = 6;
    public static final int CONCILIATOR_PROGRAM = 7;

    public static int concile(ASTNode locateNode) {
        if (locateNode == null || PhpElementConciliator.isProgram(locateNode)) {
            return 7;
        }
        if (PhpElementConciliator.isGlobalVariable(locateNode)) {
            return 1;
        }
        if (PhpElementConciliator.isFunction(locateNode)) {
            return 2;
        }
        if (PhpElementConciliator.isClassName(locateNode)) {
            return 4;
        }
        if (PhpElementConciliator.isConstant(locateNode)) {
            return 5;
        }
        if (PhpElementConciliator.isLocalVariable(locateNode)) {
            return 3;
        }
        if (PhpElementConciliator.isDispatch(locateNode)) {
            return 6;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isDispatch(ASTNode node) {
        if (!PhpElementConciliator.$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        if (node.getType() != 33) {
            if (node.getType() == 60) {
                return PhpElementConciliator.isDispatch(((Variable)node).getVariableName());
            }
            return false;
        }
        parent = node.getParent();
        if (parent.getType() == 29) {
            return parent.getParent() != null && (parent = parent.getParent()).getType() == 42;
        }
        if (parent.getType() == 60) {
            id = (Identifier)node;
            variable = (Variable)parent;
            if (id.getName().equals("this") && variable.isDollared()) {
                return false;
            }
            if (parent.getParent().getType() == 25) {
                return true;
            }
        }
        if (parent.getType() != 11) ** GOTO lbl22
        return true;
lbl-1000:
        // 1 sources

        {
            if (parent instanceof Dispatch || parent instanceof StaticDispatch) {
                return true;
            }
            parent = parent.getParent();
lbl22:
            // 2 sources

            ** while (parent != null)
        }
lbl23:
        // 1 sources

        return false;
    }

    private static boolean isConstant(ASTNode locateNode) {
        assert (locateNode != null);
        if (locateNode.getType() != 51) {
            return false;
        }
        Scalar scalar = (Scalar)locateNode;
        if (scalar.getScalarType() != 2 || scalar.getStringValue() == null) {
            return false;
        }
        int length = scalar.getStringValue().length() - 1;
        char charAtBegining = scalar.getStringValue().charAt(0);
        char charAtEnd = scalar.getStringValue().charAt(length);
        if (!PhpElementConciliator.detectString(charAtEnd) && !PhpElementConciliator.detectString(charAtBegining)) {
            return true;
        }
        ASTNode previous = locateNode.getParent();
        if (previous.getType() != 30) {
            return false;
        }
        FunctionInvocation functionInvocation = (FunctionInvocation)previous;
        if (functionInvocation.getFunctionName().getFunctionName().getType() != 33) {
            return false;
        }
        Identifier identifier = (Identifier)functionInvocation.getFunctionName().getFunctionName();
        return "define".equalsIgnoreCase(identifier.getName());
    }

    private static boolean isClassName(ASTNode locateNode) {
        StaticDispatch staticDispatch;
        assert (locateNode != null);
        if (locateNode.getType() != 33) {
            return false;
        }
        ASTNode parent = locateNode.getParent();
        int parentType = parent.getType();
        if (parentType == 14 || parentType == 12 || parentType == 40 || parentType == 9 || parentType == 27) {
            return true;
        }
        return (parentType == 53 || parentType == 52 || parentType == 10) && (staticDispatch = (StaticDispatch)parent).getClassName() == locateNode;
    }

    private static boolean isLocalVariable(ASTNode locateNode) {
        assert (locateNode != null);
        if (locateNode.getType() != 33) {
            return false;
        }
        Identifier targetIdentifier = (Identifier)locateNode;
        if (targetIdentifier.getParent().getType() != 60) {
            return false;
        }
        Variable parent = (Variable)targetIdentifier.getParent();
        if (!parent.isDollared() || targetIdentifier.getName().equals(THIS) || parent.getType() == 25) {
            return false;
        }
        if (parent.isDollared() && parent.getParent() != null && parent.getParent().getType() == 52) {
            return false;
        }
        ASTNode node = parent;
        while (node != null) {
            int type = ((ASTNode)node).getType();
            if (type == 29) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isGlobalVariable(ASTNode locateNode) {
        if (!PhpElementConciliator.$assertionsDisabled && locateNode == null) {
            throw new AssertionError();
        }
        if (locateNode.getType() == 51) {
            scalar = (Scalar)locateNode;
            return PhpElementConciliator.checkGLOBALS(scalar);
        }
        if (locateNode.getType() != 33) {
            return false;
        }
        targetIdentifier = (Identifier)locateNode;
        parent = locateNode.getParent();
        if (parent.getType() != 60) {
            return false;
        }
        variable = (Variable)parent;
        if (!variable.isDollared() || variable.getParent().getType() == 25) {
            return false;
        }
        if (parent.getParent().getType() != 52 || (staticFieldAccess = (StaticFieldAccess)parent.getParent()).getMember() != variable) ** GOTO lbl23
        return false;
lbl-1000:
        // 1 sources

        {
            if (parent.getType() == 29) {
                end = parent.getEnd();
                searchGlobal = new GlobalSeacher(end, targetIdentifier);
                parent.accept(searchGlobal);
                return searchGlobal.offset <= targetIdentifier.getStart();
            }
            parent = parent.getParent();
lbl23:
            // 2 sources

            ** while (parent != null)
        }
lbl24:
        // 1 sources

        return parent == null;
    }

    private static boolean checkGLOBALS(Scalar scalar) {
        Identifier id;
        Variable var;
        ArrayAccess arrayAccess;
        Expression variableName;
        String stringValue = scalar.getStringValue();
        if (scalar.getScalarType() != 2 || stringValue.length() < 3) {
            return false;
        }
        char charAtZero = stringValue.charAt(0);
        char charAtEnd = stringValue.charAt(stringValue.length() - 1);
        if (!PhpElementConciliator.detectString(charAtZero) || !PhpElementConciliator.detectString(charAtEnd)) {
            return false;
        }
        return scalar.getParent().getType() == 0 && (variableName = (arrayAccess = (ArrayAccess)scalar.getParent()).getVariableName()).getType() == 60 && (var = (Variable)variableName).isDollared() && var.getVariableName().getType() == 33 && (id = (Identifier)var.getVariableName()).getName().equals("GLOBALS");
    }

    private static boolean checkGlobal(Identifier targetIdentifier, GlobalStatement globalStatement) {
        Variable[] variables;
        Variable[] variableArray = variables = globalStatement.getVariables();
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable current = variableArray[n2];
            assert (current.getVariableName().getType() == 33);
            Identifier id = (Identifier)current.getVariableName();
            if (id.getName().equals(targetIdentifier.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final boolean detectString(char ch) {
        return ch == '\'' || ch == '\"';
    }

    private static boolean isFunction(ASTNode locateNode) {
        int parentParentType;
        assert (locateNode != null);
        if (locateNode.getType() != 33) {
            return false;
        }
        Identifier targetIdentifier = (Identifier)locateNode;
        ASTNode parent = targetIdentifier.getParent();
        if (parent.getType() != 29 && parent.getType() != 31) {
            return false;
        }
        int type = parent.getParent().getType();
        return !(type == 30 ? (parentParentType = parent.getParent().getParent().getType()) == 42 || parentParentType == 53 : type == 42);
    }

    private static boolean isProgram(ASTNode locateNode) {
        assert (locateNode != null);
        return locateNode.getType() == 46;
    }

    public static boolean constantAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        DefinedSearcher checkConstantVisitor = new DefinedSearcher(name);
        program.accept(checkConstantVisitor);
        return checkConstantVisitor.constantAlreadyExists();
    }

    public static boolean classNameAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        ClassSearcher checkClassVisitor = new ClassSearcher(name);
        program.accept(checkClassVisitor);
        return checkClassVisitor.classNameAlreadyExists();
    }

    public static boolean localVariableAlreadyExists(FunctionDeclaration functionDeclaration, String name) {
        assert (functionDeclaration != null && name != null);
        LocalVariableSearcher checkLocalVariable = new LocalVariableSearcher(name);
        functionDeclaration.accept(checkLocalVariable);
        return checkLocalVariable.localVariableAlreadyExists();
    }

    public static boolean functionAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        FunctionSearcher checkFunctionVisitor = new FunctionSearcher(name);
        program.accept(checkFunctionVisitor);
        return checkFunctionVisitor.functionAlreadyExists();
    }

    public static boolean globalVariableAlreadyExists(Program program, String name) {
        assert (program != null && name != null);
        GlobalVariableSearcher checkGlobalVisitor = new GlobalVariableSearcher(name);
        program.accept(checkGlobalVisitor);
        return checkGlobalVisitor.globalVariableAlreadyExists();
    }

    private static class ClassSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public ClassSearcher(String name) {
            this.name = name;
        }

        public void apply(ASTNode node) {
            if (this.exists) {
                return;
            }
            if (node.getType() == 12 || node.getType() == 40) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                if (typeDeclaration.getName().getName().equals(this.name)) {
                    this.exists = true;
                }
            } else {
                node.childrenAccept(this);
            }
        }

        public boolean classNameAlreadyExists() {
            return this.exists;
        }
    }

    private static class DefinedSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public DefinedSearcher(String name) {
            this.name = name;
        }

        public void apply(ASTNode node) {
            if (this.exists) {
                return;
            }
            if (node.getType() == 51) {
                Scalar scalar = (Scalar)node;
                String stringValue = scalar.getStringValue();
                if (scalar.getScalarType() != 2 || stringValue == null) {
                    return;
                }
                int length = stringValue.length() - 1;
                if (stringValue.charAt(0) != '\"' && stringValue.charAt(length) != '\"' && stringValue.equals(this.name)) {
                    this.exists = true;
                }
            } else if (node.getType() == 30) {
                FunctionInvocation functionInvocation = (FunctionInvocation)node;
                Expression functionName = functionInvocation.getFunctionName().getFunctionName();
                if (functionName.getType() != 33) {
                    return;
                }
                Identifier identifier = (Identifier)functionName;
                Expression[] parameters = functionInvocation.getParameters();
                if (!"define".equalsIgnoreCase(identifier.getName()) || parameters == null || parameters.length == 0) {
                    return;
                }
                Expression expression = parameters[0];
                if (expression.getType() != 51) {
                    return;
                }
                Scalar scalar = (Scalar)expression;
                String stringValue = scalar.getStringValue();
                if (stringValue.length() < 2 || stringValue.charAt(0) != '\"') {
                    return;
                }
                this.exists = this.name.equals(stringValue.substring(1, stringValue.length() - 1));
            } else {
                node.childrenAccept(this);
            }
        }

        public boolean constantAlreadyExists() {
            return this.exists;
        }
    }

    private static class FunctionSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public FunctionSearcher(String name) {
            this.name = name;
        }

        public void apply(ASTNode node) {
            if (this.exists) {
                return;
            }
            if (node.getType() != 12) {
                if (node.getType() == 29) {
                    FunctionDeclaration functionDeclaration = (FunctionDeclaration)node;
                    Identifier identifier = functionDeclaration.getFunctionName();
                    if (identifier.getName().equalsIgnoreCase(this.name)) {
                        this.exists = true;
                    }
                } else {
                    node.childrenAccept(this);
                }
            }
        }

        public boolean functionAlreadyExists() {
            return this.exists;
        }
    }

    private static class GlobalVariableSearcher
    extends ApplyAll {
        private boolean exists = false;
        private boolean isGlobalScope = true;
        private final String name;

        public GlobalVariableSearcher(String name) {
            this.name = name;
        }

        public void apply(ASTNode node) {
            if (this.exists) {
                return;
            }
            if (node.getType() == 12 || node.getType() == 29) {
                this.isGlobalScope = false;
                node.childrenAccept(this);
                this.isGlobalScope = true;
            } else if (node.getType() == 33) {
                Variable variable;
                Identifier identifier = (Identifier)node;
                if (identifier.getParent().getType() == 60 && (variable = (Variable)identifier.getParent()).isDollared() && this.isGlobalScope && this.name.equals(identifier.getName())) {
                    this.exists = true;
                }
            } else if (node.getType() == 32) {
                Variable[] variables;
                GlobalStatement globalStatement = (GlobalStatement)node;
                Variable[] variableArray = variables = globalStatement.getVariables();
                int n = variables.length;
                int n2 = 0;
                while (n2 < n) {
                    Identifier identifier;
                    Variable variable = variableArray[n2];
                    Expression variableName = variable.getVariableName();
                    if (variable.isDollared() && variableName.getType() == 33 && this.name.equals((identifier = (Identifier)variableName).getName())) {
                        this.exists = true;
                    }
                    ++n2;
                }
            } else {
                node.childrenAccept(this);
            }
        }

        public boolean globalVariableAlreadyExists() {
            return this.exists;
        }
    }

    private static class LocalVariableSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public LocalVariableSearcher(String name) {
            this.name = name;
        }

        public void apply(ASTNode node) {
            if (this.exists) {
                return;
            }
            if (node.getType() == 60) {
                Variable variable = (Variable)node;
                if (variable.isDollared()) {
                    assert (variable.getVariableName().getType() == 33);
                    Identifier identifier = (Identifier)variable.getVariableName();
                    if (identifier.getName().equals(this.name)) {
                        this.exists = true;
                    }
                }
            } else {
                node.childrenAccept(this);
            }
        }

        public boolean localVariableAlreadyExists() {
            return this.exists;
        }
    }
}

