/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ArrayCreation
extends Expression {
    private final ArrayElement[] elements;

    private ArrayCreation(int start, int end, ArrayElement[] elements) {
        super(start, end);
        assert (elements != null);
        this.elements = elements;
        int i = 0;
        while (i < elements.length) {
            elements[i].setParent(this);
            ++i;
        }
    }

    public ArrayCreation(int start, int end, List elements) {
        this(start, end, elements == null ? null : elements.toArray(new ArrayElement[elements.size()]));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ArrayCreation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</ArrayCreation>");
    }

    public int getType() {
        return 1;
    }

    public ArrayElement[] getElements() {
        return this.elements;
    }
}

