/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Assignment
extends Expression {
    public static final int OP_EQUAL = 0;
    public static final int OP_PLUS_EQUAL = 1;
    public static final int OP_MINUS_EQUAL = 2;
    public static final int OP_MUL_EQUAL = 3;
    public static final int OP_DIV_EQUAL = 4;
    public static final int OP_CONCAT_EQUAL = 5;
    public static final int OP_MOD_EQUAL = 6;
    public static final int OP_AND_EQUAL = 7;
    public static final int OP_OR_EQUAL = 8;
    public static final int OP_XOR_EQUAL = 9;
    public static final int OP_SL_EQUAL = 10;
    public static final int OP_SR_EQUAL = 11;
    private final VariableBase variable;
    private final int operator;
    private final Expression value;

    public Assignment(int start, int end, VariableBase variable, int operator, Expression value) {
        super(start, end);
        assert (variable != null && value != null);
        this.variable = variable;
        this.operator = operator;
        this.value = value;
        variable.setParent(this);
        value.setParent(this);
    }

    public static String getOperator(int operator) {
        switch (operator) {
            case 0: {
                return "=";
            }
            case 1: {
                return "+=";
            }
            case 2: {
                return "-=";
            }
            case 3: {
                return "*=";
            }
            case 4: {
                return "/=";
            }
            case 6: {
                return "%=";
            }
            case 5: {
                return ".=";
            }
            case 7: {
                return "&=";
            }
            case 8: {
                return "|=";
            }
            case 9: {
                return "^=";
            }
            case 10: {
                return "<<=";
            }
            case 11: {
                return ">>=";
            }
        }
        throw new IllegalArgumentException();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.variable.accept(visitor);
        this.value.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.variable.traverseTopDown(visitor);
        this.value.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.variable.traverseBottomUp(visitor);
        this.value.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Assignment");
        this.appendInterval(buffer);
        buffer.append(" operator='").append(Assignment.getXmlStringValue(Assignment.getOperator(this.operator))).append("'>\n");
        this.variable.toString(buffer, "\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("<Value>\n");
        this.value.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Value>\n");
        buffer.append(tab).append("</Assignment>");
    }

    public int getType() {
        return 3;
    }

    public int getOperator() {
        return this.operator;
    }

    public Expression getValue() {
        return this.value;
    }

    public VariableBase getVariable() {
        return this.variable;
    }
}

