/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class CatchClause
extends Statement {
    private final Identifier className;
    private final Variable variable;
    private final Block statement;

    public CatchClause(int start, int end, Identifier className, Variable variable, Block statement) {
        super(start, end);
        assert (className != null && variable != null && statement != null);
        this.className = className;
        this.variable = variable;
        this.statement = statement;
        className.setParent(this);
        variable.setParent(this);
        statement.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.className.accept(visitor);
        this.variable.accept(visitor);
        this.statement.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.className.traverseTopDown(visitor);
        this.variable.traverseTopDown(visitor);
        this.statement.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.className.traverseBottomUp(visitor);
        this.variable.traverseBottomUp(visitor);
        this.statement.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<CatchClause");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.className.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</ClassName>\n");
        this.variable.toString(buffer, "\t" + tab);
        buffer.append("\n");
        this.statement.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</CatchClause>");
    }

    public int getType() {
        return 9;
    }

    public Identifier getClassName() {
        return this.className;
    }

    public Block getStatement() {
        return this.statement;
    }

    public Variable getVariable() {
        return this.variable;
    }
}

