/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassDeclaration
extends TypeDeclaration {
    public static final int MODIFIER_NONE = 0;
    public static final int MODIFIER_ABSTRACT = 1;
    public static final int MODIFIER_FINAL = 2;
    private final int modifier;
    private final Identifier superClass;

    private ClassDeclaration(int start, int end, int modifier, Identifier className, Identifier superClass, Identifier[] interfaces, Block body) {
        super(start, end, className, interfaces, body);
        this.modifier = modifier;
        this.superClass = superClass;
        if (superClass != null) {
            superClass.setParent(this);
        }
    }

    public ClassDeclaration(int start, int end, int modifier, Identifier className, Identifier superClass, List interfaces, Block body) {
        this(start, end, modifier, className, superClass, interfaces == null ? null : interfaces.toArray(new Identifier[interfaces.size()]), body);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getName().accept(visitor);
        if (this.superClass != null) {
            this.superClass.accept(visitor);
        }
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            interfaces[i].accept(visitor);
            ++i;
        }
        this.getBody().accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getName().traverseTopDown(visitor);
        if (this.superClass != null) {
            this.superClass.traverseTopDown(visitor);
        }
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            interfaces[i].traverseTopDown(visitor);
            ++i;
        }
        this.getBody().traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getName().traverseBottomUp(visitor);
        if (this.superClass != null) {
            this.superClass.traverseBottomUp(visitor);
        }
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            interfaces[i].traverseBottomUp(visitor);
            ++i;
        }
        this.getBody().traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public static String getModifier(int modifier) {
        switch (modifier) {
            case 0: {
                return "";
            }
            case 1: {
                return "abstract";
            }
            case 2: {
                return "final";
            }
        }
        throw new IllegalArgumentException();
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ClassDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(ClassDeclaration.getModifier(this.modifier)).append("'>\n");
        buffer.append(tab).append("\t").append("<ClassName>\n");
        this.getName().toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</ClassName>\n");
        buffer.append(tab).append("\t").append("<SuperClassName>\n");
        if (this.superClass != null) {
            this.superClass.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("\t").append("</SuperClassName>\n");
        buffer.append(tab).append("\t").append("<Interfaces>\n");
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            interfaces[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("\t").append("</Interfaces>\n");
        this.getBody().toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</ClassDeclaration>");
    }

    public int getType() {
        return 12;
    }

    public int getModifier() {
        return this.modifier;
    }

    public Identifier getSuperClass() {
        return this.superClass;
    }
}

