/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassInstanceCreation
extends Expression {
    private final ClassName className;
    private final Expression[] ctorParams;

    public ClassInstanceCreation(int start, int end, ClassName className, Expression[] ctorParams) {
        super(start, end);
        assert (className != null && ctorParams != null);
        this.className = className;
        this.ctorParams = ctorParams;
        className.setParent(this);
        int i = 0;
        while (i < ctorParams.length) {
            ctorParams[i].setParent(this);
            ++i;
        }
    }

    public ClassInstanceCreation(int start, int end, ClassName className, List ctorParams) {
        this(start, end, className, ctorParams == null ? null : ctorParams.toArray(new Expression[ctorParams.size()]));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.className.accept(visitor);
        int i = 0;
        while (i < this.ctorParams.length) {
            this.ctorParams[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.className.traverseTopDown(visitor);
        int i = 0;
        while (i < this.ctorParams.length) {
            this.ctorParams[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.className.traverseBottomUp(visitor);
        int i = 0;
        while (i < this.ctorParams.length) {
            this.ctorParams[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ClassInstanceCreation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.className.toString(buffer, "\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("<ConstructorParameters>\n");
        int i = 0;
        while (i < this.ctorParams.length) {
            this.ctorParams[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append("\t").append(tab).append("</ConstructorParameters>\n");
        buffer.append(tab).append("</ClassInstanceCreation>");
    }

    public int getType() {
        return 13;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public Expression[] getCtorParams() {
        return this.ctorParams;
    }
}

