/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class EchoStatement
extends Statement {
    private final Expression[] expressions;

    private EchoStatement(int start, int end, Expression[] expressions) {
        super(start, end);
        assert (expressions != null);
        this.expressions = expressions;
        int i = 0;
        while (i < expressions.length) {
            expressions[i].setParent(this);
            ++i;
        }
    }

    public EchoStatement(int start, int end, List expressions) {
        this(start, end, expressions.toArray(new Expression[expressions.size()]));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<EchoStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].toString(buffer, "\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("</EchoStatement>");
    }

    public int getType() {
        return 21;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }
}

