/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FieldsDeclaration
extends BodyDeclaration {
    private final Variable[] variableNames;
    private final Expression[] initialValues;

    public FieldsDeclaration(int start, int end, int modifier, List variablesAndDefaults) {
        super(start, end, modifier);
        assert (variablesAndDefaults != null && variablesAndDefaults.size() > 0);
        this.variableNames = new Variable[variablesAndDefaults.size()];
        this.initialValues = new Expression[variablesAndDefaults.size()];
        int i = 0;
        for (ASTNode[] element : variablesAndDefaults) {
            this.variableNames[i] = (Variable)element[0];
            this.initialValues[i] = (Expression)element[1];
            element[0].setParent(this);
            if (element[1] != null) {
                element[1].setParent(this);
            }
            ++i;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.variableNames.length) {
            this.variableNames[i].accept(visitor);
            Expression expr = this.initialValues[i];
            if (expr != null) {
                expr.accept(visitor);
            }
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.variableNames.length) {
            this.variableNames[i].traverseTopDown(visitor);
            Expression expr = this.initialValues[i];
            if (expr != null) {
                expr.traverseTopDown(visitor);
            }
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.variableNames.length) {
            this.variableNames[i].traverseBottomUp(visitor);
            Expression expr = this.initialValues[i];
            if (expr != null) {
                expr.traverseBottomUp(visitor);
            }
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FieldsDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(this.getModifierString()).append("'>\n");
        int i = 0;
        while (i < this.variableNames.length) {
            buffer.append(tab).append("\t").append("<VariableName>\n");
            this.variableNames[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("</VariableName>\n");
            buffer.append(tab).append("\t").append("<InitialValue>\n");
            Expression expr = this.initialValues[i];
            if (expr != null) {
                expr.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append(tab).append("\t").append("</InitialValue>\n");
            ++i;
        }
        buffer.append(tab).append("</FieldsDeclaration>");
    }

    public int getType() {
        return 25;
    }

    public Expression[] getInitialValues() {
        return this.initialValues;
    }

    public Variable[] getVariableNames() {
        return this.variableNames;
    }
}

