/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ForEachStatement
extends Statement {
    private final Expression expression;
    private final Expression key;
    private final Expression value;
    private final Statement statement;

    public ForEachStatement(int start, int end, Expression expression, Expression key, Expression value, Statement statement) {
        super(start, end);
        assert (expression != null && value != null && statement != null);
        this.expression = expression;
        this.key = key;
        this.value = value;
        this.statement = statement;
        expression.setParent(this);
        if (key != null) {
            key.setParent(this);
        }
        value.setParent(this);
        statement.setParent(this);
    }

    public ForEachStatement(int start, int end, Expression expression, Expression value, Statement statement) {
        this(start, end, expression, null, value, statement);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expression.accept(visitor);
        if (this.key != null) {
            this.key.accept(visitor);
        }
        this.value.accept(visitor);
        this.statement.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expression.traverseTopDown(visitor);
        if (this.key != null) {
            this.key.traverseTopDown(visitor);
        }
        this.value.traverseTopDown(visitor);
        this.statement.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expression.traverseBottomUp(visitor);
        if (this.key != null) {
            this.key.traverseBottomUp(visitor);
        }
        this.value.traverseBottomUp(visitor);
        this.statement.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ForEachStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Expression>\n");
        this.expression.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Expression>\n");
        buffer.append("\t").append(tab).append("<Key>\n");
        if (this.key != null) {
            this.key.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Key>\n");
        buffer.append("\t").append(tab).append("<Value>\n");
        this.value.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Value>\n");
        this.statement.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</ForEachStatement>");
    }

    public int getType() {
        return 26;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression getKey() {
        return this.key;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Expression getValue() {
        return this.value;
    }
}

