/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FunctionDeclaration
extends Statement {
    private final boolean isReference;
    private final Identifier functionName;
    private final FormalParameter[] formalParameters;
    private final Block body;

    private FunctionDeclaration(int start, int end, Identifier functionName, FormalParameter[] formalParameters, Block body, boolean isReference) {
        super(start, end);
        assert (functionName != null && formalParameters != null);
        this.isReference = isReference;
        this.functionName = functionName;
        this.formalParameters = formalParameters;
        this.body = body;
        functionName.setParent(this);
        int i = 0;
        while (i < formalParameters.length) {
            formalParameters[i].setParent(this);
            ++i;
        }
        if (body != null) {
            body.setParent(this);
        }
    }

    public FunctionDeclaration(int start, int end, Identifier functionName, List formalParameters, Block body, boolean isReference) {
        this(start, end, functionName, formalParameters.toArray(new FormalParameter[formalParameters.size()]), body, isReference);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.functionName.accept(visitor);
        int i = 0;
        while (i < this.formalParameters.length) {
            this.formalParameters[i].accept(visitor);
            ++i;
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.functionName.traverseTopDown(visitor);
        int i = 0;
        while (i < this.formalParameters.length) {
            this.formalParameters[i].traverseTopDown(visitor);
            ++i;
        }
        if (this.body != null) {
            this.body.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.functionName.traverseBottomUp(visitor);
        int i = 0;
        while (i < this.formalParameters.length) {
            this.formalParameters[i].traverseBottomUp(visitor);
            ++i;
        }
        if (this.body != null) {
            this.body.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FunctionDeclaration");
        this.appendInterval(buffer);
        buffer.append(" isReference='").append(this.isReference).append("'>\n");
        buffer.append("\t").append(tab).append("<FunctionName>\n");
        this.functionName.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</FunctionName>\n");
        buffer.append("\t").append(tab).append("<FormalParameters>\n");
        int i = 0;
        while (i < this.formalParameters.length) {
            this.formalParameters[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append("\t").append(tab).append("</FormalParameters>\n");
        buffer.append("\t").append(tab).append("<FunctionBody>\n");
        if (this.body != null) {
            this.body.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</FunctionBody>\n");
        buffer.append(tab).append("</FunctionDeclaration>");
    }

    public int getType() {
        return 29;
    }

    public Block getBody() {
        return this.body;
    }

    public FormalParameter[] getFormalParameters() {
        return this.formalParameters;
    }

    public Identifier getFunctionName() {
        return this.functionName;
    }

    public boolean isReference() {
        return this.isReference;
    }
}

