/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FunctionInvocation
extends VariableBase {
    private final FunctionName functionName;
    private final Expression[] parameters;

    private FunctionInvocation(int start, int end, FunctionName functionName, Expression[] parameters) {
        super(start, end);
        assert (functionName != null && parameters != null);
        this.functionName = functionName;
        this.parameters = parameters;
        functionName.setParent(this);
        int i = 0;
        while (i < parameters.length) {
            parameters[i].setParent(this);
            ++i;
        }
    }

    public FunctionInvocation(int start, int end, FunctionName functionName, List parameters) {
        this(start, end, functionName, parameters == null ? null : parameters.toArray(new Expression[parameters.size()]));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.functionName.accept(visitor);
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i].accept(visitor);
            ++i;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.functionName.traverseTopDown(visitor);
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i].traverseTopDown(visitor);
            ++i;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.functionName.traverseBottomUp(visitor);
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i].traverseBottomUp(visitor);
            ++i;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FunctionInvocation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.functionName.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("<Parameters>\n");
        int i = 0;
        while (this.parameters != null && i < this.parameters.length) {
            this.parameters[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append("\t").append(tab).append("</Parameters>\n");
        buffer.append(tab).append("</FunctionInvocation>");
    }

    public int getType() {
        return 30;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public Expression[] getParameters() {
        return this.parameters;
    }
}

