/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Include
extends Expression {
    public static final int IT_REQUIRE = 0;
    public static final int IT_REQUIRE_ONCE = 1;
    public static final int IT_INCLUDE = 2;
    public static final int IT_INCLUDE_ONCE = 3;
    private final Expression expr;
    private final int includeType;

    public Include(int start, int end, Expression expr, int type) {
        super(start, end);
        assert (expr != null);
        this.expr = expr;
        this.includeType = type;
        expr.setParent(this);
    }

    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "require";
            }
            case 1: {
                return "require_once";
            }
            case 2: {
                return "include";
            }
            case 3: {
                return "include_once";
            }
        }
        throw new IllegalArgumentException();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expr.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expr.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expr.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Include");
        this.appendInterval(buffer);
        buffer.append(" kind='").append(Include.getType(this.includeType)).append("'>\n");
        this.expr.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</Include>");
    }

    public int getType() {
        return 36;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public int getIncludeType() {
        return this.includeType;
    }
}

