/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class InstanceOfExpression
extends Expression {
    private final Expression expr;
    private final ClassName className;

    public InstanceOfExpression(int start, int end, Expression expr, ClassName type) {
        super(start, end);
        assert (expr != null && type != null);
        this.expr = expr;
        this.className = type;
        expr.setParent(this);
        type.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expr.accept(visitor);
        this.className.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expr.traverseTopDown(visitor);
        this.className.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expr.traverseBottomUp(visitor);
        this.className.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<InstanceofExpression");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.expr.toString(buffer, "\t" + tab);
        buffer.append("\n");
        this.className.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</InstanceofExpression>");
    }

    public int getType() {
        return 39;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public Expression getExpr() {
        return this.expr;
    }
}

