/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class InterfaceDeclaration
extends TypeDeclaration {
    private InterfaceDeclaration(int start, int end, Identifier interfaceName, Identifier[] interfaces, Block body) {
        super(start, end, interfaceName, interfaces, body);
    }

    public InterfaceDeclaration(int start, int end, Identifier interfaceName, List interfaces, Block body) {
        this(start, end, interfaceName, interfaces.toArray(new Identifier[interfaces.size()]), body);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getName().accept(visitor);
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            interfaces[i].accept(visitor);
            ++i;
        }
        this.getBody().accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getName().traverseTopDown(visitor);
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < this.getInterfaces().length) {
            interfaces[i].traverseTopDown(visitor);
            ++i;
        }
        this.getBody().traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getName().traverseBottomUp(visitor);
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            interfaces[i].traverseBottomUp(visitor);
            ++i;
        }
        this.getBody().traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<InterfaceDeclaration");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append(tab).append("\t").append("<InterfaceName>\n");
        this.getName().toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</InterfaceName>\n");
        buffer.append(tab).append("\t").append("<Interfaces>\n");
        Identifier[] interfaces = this.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            interfaces[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append(tab).append("\t").append("</Interfaces>\n");
        this.getBody().toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</InterfaceDeclaration>");
    }

    public int getType() {
        return 40;
    }
}

