/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class PrefixExpression
extends Expression {
    public static final int OP_INC = 0;
    public static final int OP_DEC = 1;
    private final VariableBase variable;
    private final int operator;

    public PrefixExpression(int start, int end, VariableBase variable, int operator) {
        super(start, end);
        assert (variable != null);
        this.variable = variable;
        this.operator = operator;
        variable.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.variable.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.variable.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.variable.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<PrefixExpression");
        this.appendInterval(buffer);
        buffer.append(" operator='").append(PrefixExpression.getOperator(this.operator)).append("'>\n");
        this.variable.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</PrefixExpression>");
    }

    public static String getOperator(int operator) {
        switch (operator) {
            case 1: {
                return "--";
            }
            case 0: {
                return "++";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 45;
    }

    public int getOperator() {
        return this.operator;
    }

    public VariableBase getVariable() {
        return this.variable;
    }
}

