/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.php.internal.core.ast.locator.Locator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Program
extends ASTNode {
    private final Statement[] statements;
    private final Map comments;

    private Program(int start, int end, Statement[] statements, Map comments) {
        super(start, end);
        assert (statements != null && comments != null);
        this.statements = statements;
        this.comments = comments;
        int i = 0;
        while (i < statements.length) {
            statements[i].setParent(this);
            ++i;
        }
        for (Comment comment : this.getComments()) {
            comment.setParent(this);
        }
    }

    public Program(int start, int end, List statements, List commentList) {
        this(start, end, statements.toArray(new Statement[statements.size()]), Program.createCommentsMap(commentList));
    }

    public Collection getComments() {
        return this.comments.values();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].accept(visitor);
            ++i;
        }
        for (Comment comment : this.getComments()) {
            comment.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].traverseTopDown(visitor);
            ++i;
        }
        for (Comment comment : this.getComments()) {
            comment.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].traverseBottomUp(visitor);
            ++i;
        }
        for (Comment comment : this.getComments()) {
            comment.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append("<Program");
        this.appendInterval(buffer);
        buffer.append(">\n").append("\t").append("<Statements>\n");
        int i = 0;
        while (this.statements != null && i < this.statements.length) {
            this.statements[i].toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            ++i;
        }
        buffer.append("\t").append("</Statements>\n").append("\t").append("<Comments>\n");
        for (Comment comment : this.getComments()) {
            comment.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append("</Comments>\n").append("</Program>");
    }

    private static Map createCommentsMap(List commentList) {
        TreeMap<Integer, Comment> comments = new TreeMap<Integer, Comment>();
        for (Comment comment : commentList) {
            comments.put(new Integer(comment.getEnd()), comment);
        }
        return comments;
    }

    public int getType() {
        return 46;
    }

    public Statement[] getStatements() {
        return this.statements;
    }

    public ASTNode getElementAt(int offset) {
        return Locator.locateNode(this, offset);
    }
}

