/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ReturnStatement
extends Statement {
    private final Expression expr;

    public ReturnStatement(int start, int end) {
        this(start, end, null);
    }

    public ReturnStatement(int start, int end, Expression expr) {
        super(start, end);
        this.expr = expr;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        if (this.expr != null) {
            this.expr.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.expr != null) {
            this.expr.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        if (this.expr != null) {
            this.expr.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ReturnStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        if (this.expr != null) {
            this.expr.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</ReturnStatement>");
    }

    public int getType() {
        return 50;
    }

    public Expression getExpr() {
        return this.expr;
    }
}

