/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.containers;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class ZipEntryStorage
extends PlatformObject
implements IStorage {
    private ZipFile fArchive;
    private ZipEntry fZipEntry;
    private IProject fProject;

    public ZipEntryStorage(ZipFile archive, ZipEntry entry) {
        this.setArchive(archive);
        this.setZipEntry(entry);
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.getArchive().getInputStream(this.getZipEntry());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PHPCorePlugin.getPluginId(), 10001, CoreMessages.getString("zipEntryStorage_error"), (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return new Path(this.getArchive().getName()).append(this.getZipEntry().getName());
    }

    public String getName() {
        String zipEntryName = this.getZipEntry().getName();
        int index = Math.max(zipEntryName.lastIndexOf(92), zipEntryName.indexOf(47));
        if (index == -1) {
            return zipEntryName;
        }
        return zipEntryName.substring(index + 1);
    }

    public boolean isReadOnly() {
        return true;
    }

    private void setArchive(ZipFile archive) {
        this.fArchive = archive;
    }

    public ZipFile getArchive() {
        return this.fArchive;
    }

    private void setZipEntry(ZipEntry entry) {
        this.fZipEntry = entry;
    }

    public ZipEntry getZipEntry() {
        return this.fZipEntry;
    }

    public boolean equals(Object object) {
        return object instanceof ZipEntryStorage && this.getArchive().getName().equals(((ZipEntryStorage)((Object)object)).getArchive().getName()) && this.getZipEntry().getName().equals(((ZipEntryStorage)((Object)object)).getZipEntry().getName());
    }

    public int hashCode() {
        return this.getZipEntry().getName().hashCode();
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }
}

