/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.loader;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.core.documentModel.parser.PhpStructuredDocumentReParser;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class PHPDocumentLoader
extends HTMLDocumentLoader {
    private static final boolean DEBUG = false;
    private CodedReaderCreator fCodedReaderCreator;

    protected IEncodedDocument newEncodedDocument() {
        IEncodedDocument doc = super.newEncodedDocument();
        assert (doc instanceof BasicStructuredDocument);
        ((BasicStructuredDocument)doc).setReParser((IStructuredTextReParser)new PhpStructuredDocumentReParser());
        return doc;
    }

    public RegionParser getParser() {
        PhpSourceParser parser = new PhpSourceParser();
        this.addHTMLishTag(parser, "script");
        this.addHTMLishTag(parser, "style");
        return parser;
    }

    public IDocumentLoader newInstance() {
        return new PHPDocumentLoader();
    }

    public IDocumentPartitioner getDefaultDocumentPartitioner() {
        return new PHPStructuredTextPartitioner();
    }

    protected CodedReaderCreator getCodedReaderCreator() {
        if (this.fCodedReaderCreator == null) {
            this.fCodedReaderCreator = new PHPCodedReaderCreator();
        }
        return this.fCodedReaderCreator;
    }

    class PHPCodedReaderCreator
    extends CodedReaderCreator {
        PHPCodedReaderCreator() {
        }

        protected EncodingMemento createMemento(IContentDescription contentDescription) {
            String appropriateDefault = contentDescription.getContentType().getDefaultCharset();
            String detectedCharset = (String)contentDescription.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
            String unSupportedCharset = (String)contentDescription.getProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET);
            String javaCharset = contentDescription.getCharset();
            if (detectedCharset == null && appropriateDefault == null) {
                javaCharset = appropriateDefault = ResourcesPlugin.getEncoding();
                detectedCharset = appropriateDefault;
            }
            if (javaCharset == null) {
                Logger.log((int)201, (String)"charset equaled null!");
            } else if (javaCharset.length() == 0) {
                Logger.log((int)201, (String)"charset equaled emptyString!");
            }
            byte[] BOM = (byte[])contentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK);
            EncodingMemento result = PHPCodedReaderCreator.createEncodingMemento((byte[])BOM, (String)javaCharset, (String)detectedCharset, (String)unSupportedCharset, (String)appropriateDefault, null);
            if (!result.isValid()) {
                result.setAppropriateDefault(appropriateDefault);
            }
            return result;
        }
    }
}

