/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.php.internal.core.documentModel.parser.StateStack;
import org.eclipse.php.internal.core.documentModel.parser.regions.PHPRegionTypes;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class PhpLexer
implements Scanner,
PHPRegionTypes {
    public static final int YYEOF = -1;
    protected boolean asp_tags = true;
    protected int defaultReturnValue = -1;
    protected int firstPos = -1;
    protected String heredoc = null;
    protected int heredoc_len = 0;
    protected StateStack phpStack;
    public LinkedList bufferedTokens = null;
    public int bufferedLength;
    public Object bufferedState;
    private Pattern[] todos;

    protected abstract int getYy_endRead();

    protected abstract int getYy_lexical_state();

    protected abstract int getYy_markedPos();

    protected abstract int getYy_pushBackPosition();

    protected abstract int getYy_startRead();

    protected abstract void pushBack(int var1);

    public abstract char[] getYy_buffer();

    public abstract void yybegin(int var1);

    public abstract int yylength();

    public abstract String yytext();

    public abstract void reset(Reader var1, char[] var2, int[] var3);

    public abstract int yystate();

    protected abstract boolean isHeredocState(int var1);

    public abstract int[] getParamenters();

    protected static final boolean isLowerCase(String text) {
        if (text == null) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isLowerCase(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int buildStateKey() {
        int rv = this.getYy_lexical_state();
        int i = 0;
        while (i < this.phpStack.size()) {
            rv = 31 * rv + this.phpStack.get(i);
            ++i;
        }
        if (this.heredoc != null) {
            i = 0;
            while (i < this.heredoc.length()) {
                rv = 31 * rv + this.heredoc.charAt(i);
                ++i;
            }
        }
        return rv;
    }

    public Object createLexicalStateMemento() {
        if (this.bufferedTokens != null && !this.bufferedTokens.isEmpty()) {
            return this.bufferedState;
        }
        int key = this.buildStateKey();
        Object state = this.getLexerStates().get(key);
        if (state == null) {
            state = new BasicLexerState(this);
            if (this.isHeredocState(this.getYy_lexical_state())) {
                state = new HeredocState((BasicLexerState)state, this);
            }
            this.getLexerStates().put(key, state);
        }
        return state;
    }

    abstract IntHashtable getLexerStates();

    public boolean getAspTags() {
        return this.asp_tags;
    }

    public Object getEndingState() throws IOException {
        this.lexToEnd();
        return this.createLexicalStateMemento();
    }

    public int getFirstIndex() {
        return this.firstPos;
    }

    public int getMarkedPos() {
        return this.getYy_markedPos();
    }

    public void getText(int start, int length, Segment s) {
        if (start + length > this.getYy_endRead()) {
            throw new RuntimeException("bad segment !!");
        }
        s.array = this.getYy_buffer();
        s.offset = start;
        s.count = length;
    }

    public int getTokenStart() {
        return this.getYy_startRead() - this.getYy_pushBackPosition();
    }

    public void reset(Segment s) {
        this.reset(s.array, s.offset, s.count);
    }

    public void initialize(int state) {
        this.phpStack = new StateStack();
        this.yybegin(state);
    }

    public String lexToEnd() throws IOException {
        String curr;
        String last = curr = this.yylex();
        while (curr != null) {
            last = curr;
            curr = this.yylex();
        }
        return last;
    }

    public String lexToTokenAt(int offset) throws IOException {
        if (this.firstPos + offset < this.getYy_markedPos()) {
            throw new RuntimeException("Bad offset");
        }
        String t = this.yylex();
        while (this.getYy_markedPos() < this.firstPos + offset && t != null) {
            t = this.yylex();
        }
        return t;
    }

    protected void popState() {
        this.yybegin(this.phpStack.popStack());
    }

    protected void pushState(int state) {
        this.phpStack.pushStack(this.getYy_lexical_state());
        this.yybegin(state);
    }

    public void setAspTags(boolean b) {
        this.asp_tags = b;
    }

    public void setState(Object state) {
        ((Scanner.LexerState)state).restoreState(this);
    }

    public int yystart() {
        return this.getYy_startRead();
    }

    public String getNextToken() throws IOException {
        if (this.bufferedTokens != null) {
            if (this.bufferedTokens.isEmpty()) {
                this.bufferedTokens = null;
            } else {
                return this.removeFromBuffer();
            }
        }
        this.bufferedState = this.createLexicalStateMemento();
        String yylex = this.yylex();
        if (PHPPartitionTypes.isPHPDocCommentState(yylex)) {
            StringBuffer buffer = new StringBuffer();
            int length = 0;
            while (PHPPartitionTypes.isPHPDocCommentState(yylex)) {
                buffer.append(this.yytext());
                yylex = this.yylex();
                ++length;
            }
            this.bufferedTokens = new LinkedList();
            this.checkForTodo(this.bufferedTokens, "PHPDOC_COMMENT", 0, length, buffer.toString());
            this.bufferedTokens.add(new ContextRegion(yylex, 0, this.yylength(), this.yylength()));
            yylex = this.removeFromBuffer();
        } else if (PHPPartitionTypes.isPHPCommentState(yylex)) {
            this.bufferedTokens = new LinkedList();
            this.checkForTodo(this.bufferedTokens, yylex, 0, this.yylength(), this.yytext());
            yylex = this.removeFromBuffer();
        }
        if (yylex == "PHP_CLOSETAG") {
            this.pushBack(this.getLength());
        }
        return yylex;
    }

    private String removeFromBuffer() {
        ITextRegion region = (ITextRegion)this.bufferedTokens.removeFirst();
        this.bufferedLength = region.getLength();
        return region.getType();
    }

    public int getLength() {
        return this.bufferedTokens == null ? this.yylength() : this.bufferedLength;
    }

    public void setPatterns(IProject project) {
        this.todos = project != null ? TaskPatternsProvider.getInstance().getPatternsForProject(project) : TaskPatternsProvider.getInstance().getPetternsForWorkspace();
    }

    private void checkForTodo(List result, String token, int commentStart, int commentLength, String comment) {
        ArrayList matchers = this.createMatcherList(comment);
        int startPosition = 0;
        Matcher matcher = this.getMinimalMatcher(matchers, startPosition);
        ContextRegion tRegion = null;
        while (matcher != null) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex != startPosition) {
                tRegion = new ContextRegion(token, commentStart + startPosition, startIndex - startPosition, startIndex - startPosition);
                result.add(tRegion);
            }
            tRegion = new ContextRegion("TASK", commentStart + startIndex, endIndex - startIndex, endIndex - startIndex);
            result.add(tRegion);
            startPosition = endIndex;
            matcher = this.getMinimalMatcher(matchers, startPosition);
        }
        int length = commentLength - startPosition;
        result.add(new ContextRegion(token, commentStart + startPosition, length, length));
    }

    private ArrayList createMatcherList(String content) {
        ArrayList<Matcher> list = new ArrayList<Matcher>(this.todos.length);
        int i = 0;
        while (i < this.todos.length) {
            list.add(i, this.todos[i].matcher(content));
            ++i;
        }
        return list;
    }

    private Matcher getMinimalMatcher(ArrayList matchers, int startPosition) {
        Matcher minimal = null;
        int size = matchers.size();
        int i = 0;
        while (i < size) {
            Matcher tmp = (Matcher)matchers.get(i);
            if (tmp.find(startPosition)) {
                if (minimal == null || tmp.start() < minimal.start()) {
                    minimal = tmp;
                }
                ++i;
                continue;
            }
            matchers.remove(i);
            --size;
        }
        return minimal;
    }

    private static class BasicLexerState
    implements Scanner.LexerState {
        private final byte lexicalState;
        private StateStack phpStack;

        public BasicLexerState(PhpLexer lexer) {
            if (!lexer.phpStack.isEmpty()) {
                this.phpStack = lexer.phpStack.createClone();
            }
            this.lexicalState = (byte)lexer.getYy_lexical_state();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState tmp = (BasicLexerState)o;
            if (tmp.lexicalState != this.lexicalState) {
                return false;
            }
            if (this.phpStack != null && !this.phpStack.equals(tmp.phpStack)) {
                return false;
            }
            return this.phpStack == tmp.phpStack;
        }

        public boolean equalsCurrentStack(Scanner.LexerState obj) {
            StateStack otherActiveStack;
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState tmp = (BasicLexerState)obj;
            if (tmp.lexicalState != this.lexicalState) {
                return false;
            }
            StateStack activeStack = this.getActiveStack();
            return activeStack == (otherActiveStack = tmp.getActiveStack()) || activeStack != null && activeStack.equals(otherActiveStack);
        }

        public boolean equalsTop(Scanner.LexerState obj) {
            return obj != null && obj.getTopState() == this.lexicalState;
        }

        protected StateStack getActiveStack() {
            return this.phpStack;
        }

        public int getTopState() {
            return this.lexicalState;
        }

        public boolean isSubstateOf(int state) {
            if (this.lexicalState == state) {
                return true;
            }
            StateStack activeStack = this.getActiveStack();
            if (activeStack == null) {
                return false;
            }
            return activeStack.contains(state);
        }

        public void restoreState(Scanner scanner) {
            PhpLexer lexer = (PhpLexer)scanner;
            if (this.phpStack == null) {
                lexer.phpStack.clear();
            } else {
                lexer.phpStack.copyFrom(this.phpStack);
            }
            lexer.yybegin(this.lexicalState);
        }

        public String toString() {
            StateStack stack = this.getActiveStack();
            String stackStr = stack == null ? "null" : stack.toString();
            return "Stack: " + stackStr + ", currState: " + this.lexicalState;
        }
    }

    private static class HeredocState
    implements Scanner.LexerState {
        private final String myHeredoc;
        private final BasicLexerState theState;

        public HeredocState(BasicLexerState state, PhpLexer lexer) {
            this.theState = state;
            this.myHeredoc = lexer.heredoc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HeredocState other = (HeredocState)obj;
            if (this.myHeredoc == null ? other.myHeredoc != null : !this.myHeredoc.equals(other.myHeredoc)) {
                return false;
            }
            return !(this.theState == null ? other.theState != null : !this.theState.equals(other.theState));
        }

        public boolean equalsCurrentStack(Scanner.LexerState obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HeredocState)) {
                return false;
            }
            return this.theState.equals(((HeredocState)obj).theState);
        }

        public boolean equalsTop(Scanner.LexerState obj) {
            return this.theState.equalsTop(obj);
        }

        public int getTopState() {
            return this.theState.getTopState();
        }

        public boolean isSubstateOf(int state) {
            return this.theState.isSubstateOf(state);
        }

        public void restoreState(Scanner scanner) {
            PhpLexer lexer = (PhpLexer)scanner;
            this.theState.restoreState(lexer);
            lexer.heredoc = this.myHeredoc;
            lexer.heredoc_len = this.myHeredoc.length();
        }
    }
}

